/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.sync;

import com.aliyun.core.io.NonCloseableInputStream;
import com.aliyun.core.utils.BinaryUtils;
import com.aliyun.core.utils.FunctionalUtils;
import com.aliyun.core.utils.IOUtils;
import darabonba.core.TeaRequestBody;
import darabonba.core.internal.sync.FileContentStreamProvider;
import darabonba.core.sync.ContentStreamProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;

public interface RequestBody
extends TeaRequestBody {
    public InputStream newStream();

    public static RequestBody fromFile(File file) {
        return RequestBody.fromFile(file.toPath(), null);
    }

    public static RequestBody fromFile(Path path) {
        return RequestBody.fromFile(path, null);
    }

    public static RequestBody fromFile(Path path, String mimetype) {
        return RequestBody.fromContentProvider(new FileContentStreamProvider(path), FunctionalUtils.invokeSafely(() -> Files.size(path)), mimetype);
    }

    public static RequestBody fromInputStream(InputStream inputStream) {
        return RequestBody.fromInputStream(inputStream, null, null);
    }

    public static RequestBody fromInputStream(InputStream inputStream, Long contentLength) {
        return RequestBody.fromInputStream(inputStream, contentLength, null);
    }

    public static RequestBody fromInputStream(InputStream inputStream, Long contentLength, String mimetype) {
        IOUtils.markStreamWithMaxReadLimit(inputStream);
        NonCloseableInputStream nonCloseable = new NonCloseableInputStream(inputStream);
        return RequestBody.fromContentProvider(() -> {
            if (nonCloseable.markSupported()) {
                FunctionalUtils.invokeSafely(nonCloseable::reset);
            }
            return nonCloseable;
        }, contentLength, mimetype);
    }

    public static RequestBody fromString(String contents) {
        return RequestBody.fromString(contents, StandardCharsets.UTF_8, null);
    }

    public static RequestBody fromString(String contents, Charset cs) {
        return RequestBody.fromString(contents, cs, null);
    }

    public static RequestBody fromString(String contents, Charset cs, String mimetype) {
        return RequestBody.fromBytesDirect(contents.getBytes(cs), mimetype);
    }

    public static RequestBody fromBytes(byte[] bytes) {
        return RequestBody.fromBytesDirect(Arrays.copyOf(bytes, bytes.length));
    }

    public static RequestBody fromBytes(byte[] bytes, String mimetype) {
        return RequestBody.fromBytesDirect(Arrays.copyOf(bytes, bytes.length), mimetype);
    }

    public static RequestBody fromByteBuffer(ByteBuffer byteBuffer) {
        return RequestBody.fromBytesDirect(BinaryUtils.copyAllBytesFrom(byteBuffer));
    }

    public static RequestBody fromRemainingByteBuffer(ByteBuffer byteBuffer) {
        return RequestBody.fromBytesDirect(BinaryUtils.copyRemainingBytesFrom(byteBuffer));
    }

    public static RequestBody empty() {
        return RequestBody.fromBytesDirect(new byte[0]);
    }

    public static RequestBody fromBytesDirect(byte[] bytes) {
        return RequestBody.fromBytesDirect(bytes, null);
    }

    public static RequestBody fromBytesDirect(byte[] bytes, String mimetype) {
        return RequestBody.fromContentProvider(() -> new ByteArrayInputStream(bytes), Long.valueOf(bytes.length), mimetype);
    }

    public static RequestBody fromContentProvider(final ContentStreamProvider provider, final Long contentLength, final String mimetype) {
        return new RequestBody(){

            @Override
            public Optional<Long> contentLength() {
                return contentLength != null ? Optional.of(contentLength) : Optional.empty();
            }

            @Override
            public Optional<String> contentType() {
                return mimetype != null ? Optional.of(mimetype) : Optional.empty();
            }

            @Override
            public InputStream newStream() {
                return provider.newStream();
            }
        };
    }
}

