/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.utils;

import com.aliyun.core.utils.EncodeUtil;
import com.aliyun.core.utils.StringUtils;
import darabonba.core.TeaModel;
import darabonba.core.TeaPair;
import darabonba.core.exception.TeaException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.UUID;

public final class CommonUtil {
    public static boolean isUnset(Object object) {
        return null == object;
    }

    public static Object defaultAny(Object inputValue, Object defaultValue) {
        if (inputValue == null) {
            return defaultValue;
        }
        return inputValue;
    }

    public static Map<String, Object> assertAsMap(Object object) {
        if (null != object && Map.class.isAssignableFrom(object.getClass())) {
            return (Map)object;
        }
        throw new TeaException("The value is not a map", new RuntimeException("The value is not a object"));
    }

    public static List<Object> assertAsArray(Object object) {
        if (null != object && List.class.isAssignableFrom(object.getClass())) {
            return (List)object;
        }
        throw new TeaException("The value is not a array", new RuntimeException("The value is not a array"));
    }

    public static InputStream assertAsReadable(Object value) {
        if (null != value && InputStream.class.isAssignableFrom(value.getClass())) {
            return (InputStream)value;
        }
        throw new TeaException("The value is not a readable", new RuntimeException("The value is not a readable"));
    }

    public static byte[] assertAsBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw new TeaException("The value is not a byteArray", new RuntimeException("The value is not a byteArray"));
    }

    public static Number assertAsNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new TeaException("The value is not a Number", new RuntimeException("The value is not a Number"));
    }

    public static String assertAsString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new TeaException("The value is not a String", new RuntimeException("The value is not a String"));
    }

    public static Boolean assertAsBoolean(Object object) {
        try {
            return (Boolean)object;
        }
        catch (Exception e) {
            throw new TeaException("The value is not a Boolean", e);
        }
    }

    public static String getNonce() {
        StringBuffer uniqueNonce = new StringBuffer();
        UUID uuid = UUID.randomUUID();
        uniqueNonce.append(uuid.toString());
        uniqueNonce.append(System.currentTimeMillis());
        uniqueNonce.append(Thread.currentThread().getId());
        return uniqueNonce.toString();
    }

    public static String getDateUTCString() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(new Date());
    }

    public static boolean isNot2xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 300;
    }

    public static boolean is2xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 200 && code.intValue() < 300;
    }

    public static boolean is3xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 300 && code.intValue() < 400;
    }

    public static boolean is4xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 400 && code.intValue() < 500;
    }

    public static boolean is5xx(Number code) {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 500 && code.intValue() < 600;
    }

    public static <T> Map<String, T> buildMap(TeaPair ... pairs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < pairs.length; ++i) {
            TeaPair pair = pairs[i];
            map.put(pair.key, pair.value);
        }
        return map;
    }

    public static <T> Map<String, T> merge(Class<T> t, Object ... maps) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        Map<String, Object> map = null;
        for (int i = 0; i < maps.length; ++i) {
            if (null == maps[i]) continue;
            map = TeaModel.class.isAssignableFrom(maps[i].getClass()) ? TeaModel.buildMap((TeaModel)maps[i]) : (Map<String, Object>)maps[i];
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                if (null == entry.getValue()) continue;
                out.put(entry.getKey(), entry.getValue());
            }
        }
        return out;
    }

    public static String getEncodePath(String path) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty(path) || "/".equals(path)) {
            return path;
        }
        String[] strs = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            sb.append(EncodeUtil.percentEncode(strs[i]));
            sb.append("/");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static String getTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return df.format(new Date());
    }

    public static Object parseNumber(Object value, Class clazz) {
        if (value instanceof Double && (clazz == Long.class || clazz == Long.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.longValue();
        }
        if (value instanceof Double && (clazz == Integer.class || clazz == Integer.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.intValue();
        }
        if (value instanceof Double && (clazz == Float.class || clazz == Float.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return Float.valueOf(bigDecimal.floatValue());
        }
        return value;
    }
}

