/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.utils;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.com.google.gson.Gson;
import com.aliyun.core.annotation.EnumType;
import com.aliyun.core.utils.EncodeUtil;
import com.aliyun.core.utils.StringUtils;
import darabonba.core.RequestModel;
import darabonba.core.TeaModel;
import darabonba.core.exception.TeaException;
import darabonba.core.utils.CommonUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModelUtil {
    private static final String UTF8 = "UTF-8";
    private static final String SEPARATOR = "&";

    public static Map<String, String> queryConvert(RequestModel model) {
        return ModelUtil.query(model.getQueryParameters());
    }

    public static Object bodyConvert(RequestModel model) {
        return ModelUtil.parseObject(model.getBodyParameters());
    }

    public static InputStream streamConvert(RequestModel model) {
        return ModelUtil.parseStream(model.getBodyParameters());
    }

    public static Map<String, String> headersConvert(RequestModel model) {
        return ModelUtil.parseHeaders(model.getHeaderParameters());
    }

    public static Map<String, String> hostConvert(RequestModel model) {
        return model.getHostParameters();
    }

    public static String pathConvert(RequestModel model, String pathRegex) throws UnsupportedEncodingException {
        Map<String, String> pathMap = model.getPathParameters();
        String path = pathRegex;
        for (Map.Entry<String, String> entry : pathMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || "null".equals(value)) {
                value = "";
            }
            String regex = "\\{" + key + "\\}";
            path = path.replaceAll(regex, URLEncoder.encode(value, UTF8));
        }
        return path;
    }

    public static Map<String, String> query(Map<String, ?> filter) {
        HashMap<String, String> outMap = new HashMap<String, String>();
        if (!CommonUtil.isUnset(filter)) {
            ModelUtil.processObject(outMap, "", filter);
        }
        return outMap;
    }

    private static void processObject(Map<String, String> map, String key, Object value) {
        if (CommonUtil.isUnset(value)) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                ModelUtil.processObject(map, key + "." + (i + 1), list.get(i));
            }
        } else if (value instanceof TeaModel) {
            Map<String, Object> subMap = ((TeaModel)value).toMap();
            for (Map.Entry<String, Object> entry : subMap.entrySet()) {
                ModelUtil.processObject(map, key + "." + entry.getKey(), entry.getValue());
            }
        } else if (value instanceof Map) {
            Map subMap = (Map)value;
            for (Map.Entry entry : subMap.entrySet()) {
                ModelUtil.processObject(map, key + "." + (String)entry.getKey(), entry.getValue());
            }
        } else {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            if (!CommonUtil.isUnset(value.getClass().getDeclaredAnnotation(EnumType.class))) {
                try {
                    Method method = value.getClass().getDeclaredMethod("getValue", new Class[0]);
                    map.put(key, String.valueOf(method.invoke(value, new Object[0])));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new TeaException(e);
                }
            } else if (value instanceof byte[]) {
                try {
                    map.put(key, new String((byte[])value, UTF8));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TeaException(e);
                }
            } else {
                map.put(key, String.valueOf(value));
            }
        }
    }

    public static Object parseObject(Object o) {
        if (CommonUtil.isUnset(o)) {
            return null;
        }
        Class<?> clazz = o.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)o;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : list) {
                result.add(ModelUtil.parseObject(object));
            }
            return result;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)o;
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                if (InputStream.class.isAssignableFrom(entry.getValue().getClass())) {
                    return null;
                }
                result.put(entry.getKey(), ModelUtil.parseObject(entry.getValue()));
            }
            return result;
        }
        if (TeaModel.class.isAssignableFrom(clazz)) {
            return ((TeaModel)o).toMap(false);
        }
        if (!CommonUtil.isUnset(clazz.getDeclaredAnnotation(EnumType.class))) {
            try {
                Method method = clazz.getDeclaredMethod("getValue", new Class[0]);
                return method.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new TeaException(e);
            }
        }
        return o;
    }

    public static InputStream parseStream(Map<String, Object> streamMap) {
        if (CommonUtil.isUnset(streamMap)) {
            return null;
        }
        for (Map.Entry<String, Object> entry : streamMap.entrySet()) {
            if (!InputStream.class.isAssignableFrom(entry.getValue().getClass())) continue;
            return (InputStream)entry.getValue();
        }
        return null;
    }

    public static Map<String, String> parseHeaders(Map<String, Object> headersMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : headersMap.entrySet()) {
            if (Map.class.isAssignableFrom(entry.getValue().getClass())) {
                Map map = (Map)entry.getValue();
                String key = entry.getKey();
                for (Map.Entry item : map.entrySet()) {
                    result.put(key.replace("*", (CharSequence)item.getKey()), String.valueOf(item.getValue()));
                }
                continue;
            }
            if (!CommonUtil.isUnset(entry.getValue().getClass().getDeclaredAnnotation(EnumType.class))) {
                try {
                    Method method = entry.getValue().getClass().getDeclaredMethod("getValue", new Class[0]);
                    result.put(entry.getKey(), String.valueOf(method.invoke(entry.getValue(), new Object[0])));
                    continue;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new TeaException(e);
                }
            }
            if (entry.getValue() instanceof byte[]) {
                try {
                    result.put(entry.getKey(), new String((byte[])entry.getValue(), UTF8));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new TeaException(e);
                }
            }
            result.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return result;
    }

    public static String toFormString(Map<String, ?> map) {
        if (CommonUtil.isUnset(map)) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (StringUtils.isEmpty(entry.getValue())) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(SEPARATOR);
                }
                result.append(URLEncoder.encode(entry.getKey(), UTF8));
                result.append("=");
                result.append(URLEncoder.encode(String.valueOf(entry.getValue()), UTF8));
            }
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
        return result.toString();
    }

    private static String toFormWithSymbol(Map<String, ?> filter, String symbol) {
        Map<String, String> map = ModelUtil.query(filter);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringUtils.isEmpty((Object)entry.getValue())) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(symbol);
                }
                result.append(URLEncoder.encode(entry.getKey(), UTF8));
                result.append("=");
                result.append(URLEncoder.encode(String.valueOf(entry.getValue()), UTF8));
            }
        }
        catch (Exception e) {
            throw new TeaException(e.getMessage(), e);
        }
        return result.toString();
    }

    public static String composeUrl(String host, Map<String, String> query, String protocol, String pathname) {
        Map<String, String> queries = query;
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(StringUtils.isEmpty(protocol) ? "https" : protocol);
        urlBuilder.append("://").append(host);
        if (!StringUtils.isEmpty(pathname)) {
            urlBuilder.append(pathname);
        }
        if (queries.size() > 0) {
            if (urlBuilder.indexOf("?") >= 1) {
                urlBuilder.append(SEPARATOR);
            } else {
                urlBuilder.append("?");
            }
            try {
                for (Map.Entry<String, String> entry : queries.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    if (null == val) continue;
                    urlBuilder.append(EncodeUtil.encode(key));
                    urlBuilder.append("=");
                    urlBuilder.append(EncodeUtil.encode(val));
                    urlBuilder.append(SEPARATOR);
                }
            }
            catch (Exception e) {
                throw new TeaException(e.getMessage(), e);
            }
            int strIndex = urlBuilder.length();
            urlBuilder.deleteCharAt(strIndex - 1);
        }
        return urlBuilder.toString();
    }

    public static String shrinkSpecifiedStyle(Object array, String prefix, String style) {
        if (null == array) {
            return "";
        }
        switch (style) {
            case "repeatList": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(prefix, array);
                return ModelUtil.toFormWithSymbol(map, "&&");
            }
            case "simple": 
            case "spaceDelimited": 
            case "pipeDelimited": {
                return ModelUtil.flatArray((List)array, style);
            }
            case "json": {
                Class<?> clazz = array.getClass();
                List list = new ArrayList();
                if (List.class.isAssignableFrom(clazz)) {
                    list = (List)array;
                }
                if (list.size() > 0 && TeaModel.class.isAssignableFrom(list.get(0).getClass())) {
                    List teaModels = (List)array;
                    ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
                    for (TeaModel teaModel : teaModels) {
                        mapList.add(teaModel.toMap());
                    }
                    return new Gson().toJson(mapList);
                }
                return new Gson().toJson(array);
            }
        }
        return "";
    }

    private static String flatArray(List array, String sty) {
        if (array == null || array.size() <= 0 || sty == null) {
            return "";
        }
        String flag = "simple".equalsIgnoreCase(sty) ? "," : ("spaceDelimited".equalsIgnoreCase(sty) ? " " : "|");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            sb.append(array.get(i));
            sb.append(flag);
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

