/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source;

import java.util.Properties;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@Internal
public class DynamicKafkaSourceOptions {
    public static final ConfigOption<Long> STREAM_METADATA_DISCOVERY_INTERVAL_MS = ConfigOptions.key((String)"stream-metadata-discovery-interval-ms").longType().defaultValue((Object)-1L).withDescription("The interval in milliseconds for the source to discover the changes in stream metadata. A non-positive value disables the stream metadata discovery.");
    public static final ConfigOption<Integer> STREAM_METADATA_DISCOVERY_FAILURE_THRESHOLD = ConfigOptions.key((String)"stream-metadata-discovery-failure-threshold").intType().defaultValue((Object)1).withDescription("The number of consecutive failures before letting the exception from Kafka metadata service discovery trigger jobmanager failure and global failover. The default is one to at least catch startup failures.");

    private DynamicKafkaSourceOptions() {
    }

    @Internal
    public static <T> T getOption(Properties props, ConfigOption<?> configOption, Function<String, T> parser) {
        String value = props.getProperty(configOption.key());
        return (T)(value == null ? configOption.defaultValue() : parser.apply(value));
    }
}

