/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.enumerator.subscriber;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaMetadataService;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaStream;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.subscriber.KafkaStreamSubscriber;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableSet;

@Internal
public class StreamPatternSubscriber
implements KafkaStreamSubscriber {
    private final Pattern streamPattern;

    public StreamPatternSubscriber(Pattern streamPattern) {
        this.streamPattern = streamPattern;
    }

    @Override
    public Set<KafkaStream> getSubscribedStreams(KafkaMetadataService kafkaMetadataService) {
        Set<KafkaStream> allStreams = kafkaMetadataService.getAllStreams();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (KafkaStream kafkaStream : allStreams) {
            String streamId = kafkaStream.getStreamId();
            if (!this.streamPattern.matcher(streamId).find()) continue;
            builder.add((Object)kafkaStream);
        }
        return builder.build();
    }
}

