/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.dynamic.source.metrics.KafkaClusterMetricGroup;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KafkaClusterMetricGroupManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaClusterMetricGroupManager.class);
    private final Map<String, AbstractMetricGroup> metricGroups = new HashMap<String, AbstractMetricGroup>();

    public void register(String kafkaClusterId, KafkaClusterMetricGroup kafkaClusterMetricGroup) {
        if (kafkaClusterMetricGroup.getInternalClusterSpecificMetricGroup() instanceof AbstractMetricGroup) {
            this.metricGroups.put(kafkaClusterId, (AbstractMetricGroup)kafkaClusterMetricGroup.getInternalClusterSpecificMetricGroup());
        } else {
            logger.warn("MetricGroup {} is an instance of {}, which is not supported. Please use an implementation of AbstractMetricGroup.", (Object)kafkaClusterMetricGroup.getInternalClusterSpecificMetricGroup(), (Object)kafkaClusterMetricGroup.getInternalClusterSpecificMetricGroup().getClass().getSimpleName());
        }
    }

    public void close(String kafkaClusterId) {
        AbstractMetricGroup metricGroup = this.metricGroups.remove(kafkaClusterId);
        if (metricGroup != null) {
            metricGroup.close();
        } else {
            logger.warn("Tried to close metric group for {} but it is not registered for lifecycle management", (Object)kafkaClusterId);
        }
    }

    @Override
    public void close() throws Exception {
        for (AbstractMetricGroup metricGroup : this.metricGroups.values()) {
            metricGroup.close();
        }
    }
}

