/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.split;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.dynamic.source.split.DynamicKafkaSourceSplit;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplit;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.shaded.guava31.com.google.common.io.ByteStreams;

@Internal
public class DynamicKafkaSourceSplitSerializer
implements SimpleVersionedSerializer<DynamicKafkaSourceSplit> {
    private static final int VERSION_1 = 1;
    private final KafkaPartitionSplitSerializer kafkaPartitionSplitSerializer = new KafkaPartitionSplitSerializer();

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DynamicKafkaSourceSplit split) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeUTF(split.getKafkaClusterId());
                out.writeInt(this.kafkaPartitionSplitSerializer.getVersion());
                out.write(this.kafkaPartitionSplitSerializer.serialize(split.getKafkaPartitionSplit()));
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public DynamicKafkaSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            DynamicKafkaSourceSplit dynamicKafkaSourceSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                String kafkaClusterId = in.readUTF();
                int kafkaPartitionSplitSerializerVersion = in.readInt();
                KafkaPartitionSplit kafkaPartitionSplit = this.kafkaPartitionSplitSerializer.deserialize(kafkaPartitionSplitSerializerVersion, ByteStreams.toByteArray((InputStream)in));
                dynamicKafkaSourceSplit = new DynamicKafkaSourceSplit(kafkaClusterId, kafkaPartitionSplit);
            }
            return dynamicKafkaSourceSplit;
        }
    }
}

