/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.kafka.sink.EvolvingKafkaSinkContext;
import org.apache.flink.connector.kafka.sink.ExactlyOnceKafkaWriter;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaSink;
import org.apache.flink.connector.kafka.sink.KafkaWriter;
import org.apache.flink.connector.kafka.sink.KafkaWriterState;

@PublicEvolving
public class EvolvingKafkaSink<IN>
extends KafkaSink<IN> {
    EvolvingKafkaSink(DeliveryGuarantee deliveryGuarantee, Properties kafkaProducerConfig, String transactionalIdPrefix, KafkaRecordSerializationSchema<IN> recordSerializer) {
        super(deliveryGuarantee, kafkaProducerConfig, transactionalIdPrefix, recordSerializer);
    }

    @Override
    @Internal
    public KafkaWriter<IN> createWriter(Sink.InitContext context) throws IOException {
        return this.restoreWriter(context, (Collection)Collections.emptyList());
    }

    @Override
    @Internal
    public KafkaWriter<IN> restoreWriter(Sink.InitContext context, Collection<KafkaWriterState> recoveredState) {
        KafkaWriter writer = this.getDeliveryGuarantee() == DeliveryGuarantee.EXACTLY_ONCE ? new ExactlyOnceKafkaWriter(this.getDeliveryGuarantee(), this.getKafkaProducerConfig(), this.getTransactionalIdPrefix(), context, this.getRecordSerializer(), context.asSerializationSchemaInitializationContext(), recoveredState, new EvolvingKafkaSinkContext(context.getSubtaskId(), context.getNumberOfParallelSubtasks(), this.getKafkaProducerConfig(), (RuntimeContext)context.getRuntimeContext().get())) : new KafkaWriter(this.getDeliveryGuarantee(), this.getKafkaProducerConfig(), context, this.getRecordSerializer(), context.asSerializationSchemaInitializationContext(), new EvolvingKafkaSinkContext(context.getSubtaskId(), context.getNumberOfParallelSubtasks(), this.getKafkaProducerConfig(), (RuntimeContext)context.getRuntimeContext().get()));
        writer.initialize();
        return writer;
    }
}

