/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.initializer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;

class TimestampOffsetsInitializer
implements OffsetsInitializer {
    private static final long serialVersionUID = 2932230571773627233L;
    private final long startingTimestamp;

    TimestampOffsetsInitializer(long startingTimestamp) {
        this.startingTimestamp = startingTimestamp;
    }

    @Override
    public Map<TopicPartition, Long> getPartitionOffsets(Collection<TopicPartition> partitions, OffsetsInitializer.PartitionOffsetsRetriever partitionOffsetsRetriever) {
        HashMap<TopicPartition, Long> startingTimestamps = new HashMap<TopicPartition, Long>();
        HashMap<TopicPartition, Long> initialOffsets = new HashMap<TopicPartition, Long>();
        Map<TopicPartition, Long> endOffsets = partitionOffsetsRetriever.endOffsets(partitions);
        partitions.forEach(tp -> startingTimestamps.put((TopicPartition)tp, this.startingTimestamp));
        Map<TopicPartition, OffsetAndTimestamp> topicPartitionOffsetAndTimestampMap = partitionOffsetsRetriever.offsetsForTimes(startingTimestamps);
        for (TopicPartition tp2 : partitions) {
            if (topicPartitionOffsetAndTimestampMap.containsKey(tp2)) {
                initialOffsets.put(tp2, topicPartitionOffsetAndTimestampMap.get(tp2).offset());
                continue;
            }
            initialOffsets.put(tp2, endOffsets.get(tp2));
        }
        return initialOffsets;
    }

    @Override
    public OffsetResetStrategy getAutoOffsetResetStrategy() {
        return OffsetResetStrategy.LATEST;
    }
}

