/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TopicDescription;

class KafkaSubscriberUtils {
    private KafkaSubscriberUtils() {
    }

    static Map<String, TopicDescription> getAllTopicMetadata(AdminClient adminClient) {
        try {
            Set<String> allTopicNames = adminClient.listTopics().names().get();
            return KafkaSubscriberUtils.getTopicMetadata(adminClient, allTopicNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get metadata for all topics.", e);
        }
    }

    static Map<String, TopicDescription> getTopicMetadata(AdminClient adminClient, Pattern topicPattern) {
        try {
            Set<String> allTopicNames = adminClient.listTopics().names().get();
            Set<String> matchedTopicNames = allTopicNames.stream().filter(name -> topicPattern.matcher((CharSequence)name).matches()).collect(Collectors.toSet());
            return KafkaSubscriberUtils.getTopicMetadata(adminClient, matchedTopicNames);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to get metadata for %s topics.", topicPattern.pattern()), e);
        }
    }

    static Map<String, TopicDescription> getTopicMetadata(AdminClient adminClient, Set<String> topicNames) {
        try {
            return adminClient.describeTopics(topicNames).allTopicNames().get();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to get metadata for topics %s.", topicNames), e);
        }
    }
}

