/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class QuorumInfo {
    private final int leaderId;
    private final long leaderEpoch;
    private final long highWatermark;
    private final List<ReplicaState> voters;
    private final List<ReplicaState> observers;

    QuorumInfo(int leaderId, long leaderEpoch, long highWatermark, List<ReplicaState> voters, List<ReplicaState> observers) {
        this.leaderId = leaderId;
        this.leaderEpoch = leaderEpoch;
        this.highWatermark = highWatermark;
        this.voters = voters;
        this.observers = observers;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public long leaderEpoch() {
        return this.leaderEpoch;
    }

    public long highWatermark() {
        return this.highWatermark;
    }

    public List<ReplicaState> voters() {
        return this.voters;
    }

    public List<ReplicaState> observers() {
        return this.observers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuorumInfo that = (QuorumInfo)o;
        return this.leaderId == that.leaderId && this.leaderEpoch == that.leaderEpoch && this.highWatermark == that.highWatermark && Objects.equals(this.voters, that.voters) && Objects.equals(this.observers, that.observers);
    }

    public int hashCode() {
        return Objects.hash(this.leaderId, this.leaderEpoch, this.highWatermark, this.voters, this.observers);
    }

    public String toString() {
        return "QuorumInfo(leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", highWatermark=" + this.highWatermark + ", voters=" + this.voters + ", observers=" + this.observers + ')';
    }

    public static class ReplicaState {
        private final int replicaId;
        private final long logEndOffset;
        private final OptionalLong lastFetchTimestamp;
        private final OptionalLong lastCaughtUpTimestamp;

        ReplicaState() {
            this(0, 0L, OptionalLong.empty(), OptionalLong.empty());
        }

        ReplicaState(int replicaId, long logEndOffset, OptionalLong lastFetchTimestamp, OptionalLong lastCaughtUpTimestamp) {
            this.replicaId = replicaId;
            this.logEndOffset = logEndOffset;
            this.lastFetchTimestamp = lastFetchTimestamp;
            this.lastCaughtUpTimestamp = lastCaughtUpTimestamp;
        }

        public int replicaId() {
            return this.replicaId;
        }

        public long logEndOffset() {
            return this.logEndOffset;
        }

        public OptionalLong lastFetchTimestamp() {
            return this.lastFetchTimestamp;
        }

        public OptionalLong lastCaughtUpTimestamp() {
            return this.lastCaughtUpTimestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaState that = (ReplicaState)o;
            return this.replicaId == that.replicaId && this.logEndOffset == that.logEndOffset && this.lastFetchTimestamp.equals(that.lastFetchTimestamp) && this.lastCaughtUpTimestamp.equals(that.lastCaughtUpTimestamp);
        }

        public int hashCode() {
            return Objects.hash(this.replicaId, this.logEndOffset, this.lastFetchTimestamp, this.lastCaughtUpTimestamp);
        }

        public String toString() {
            return "ReplicaState(replicaId=" + this.replicaId + ", logEndOffset=" + this.logEndOffset + ", lastFetchTimestamp=" + this.lastFetchTimestamp + ", lastCaughtUpTimestamp=" + this.lastCaughtUpTimestamp + ')';
        }
    }
}

