/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;

public class CreateTopicsRequestDataJsonConverter {
    public static CreateTopicsRequestData read(JsonNode _node, short _version) {
        CreateTopicsRequestData.CreatableTopicCollection _collection;
        CreateTopicsRequestData _object = new CreateTopicsRequestData();
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("CreateTopicsRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        _object.topics = _collection = new CreateTopicsRequestData.CreatableTopicCollection(_topicsNode.size());
        for (JsonNode _element : _topicsNode) {
            _collection.add(CreatableTopicJsonConverter.read(_element, _version));
        }
        JsonNode _timeoutMsNode = _node.get("timeoutMs");
        if (_timeoutMsNode == null) {
            throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'timeoutMs', which is mandatory in version " + _version);
        }
        _object.timeoutMs = MessageUtil.jsonNodeToInt(_timeoutMsNode, "CreateTopicsRequestData");
        JsonNode _validateOnlyNode = _node.get("validateOnly");
        if (_validateOnlyNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'validateOnly', which is mandatory in version " + _version);
            }
            _object.validateOnly = false;
        } else {
            if (!_validateOnlyNode.isBoolean()) {
                throw new RuntimeException("CreateTopicsRequestData expected Boolean type, but got " + _node.getNodeType());
            }
            _object.validateOnly = _validateOnlyNode.asBoolean();
        }
        return _object;
    }

    public static JsonNode write(CreateTopicsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (CreateTopicsRequestData.CreatableTopic _element : _object.topics) {
            _topicsArray.add(CreatableTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        _node.set("timeoutMs", (JsonNode)new IntNode(_object.timeoutMs));
        if (_version >= 1) {
            _node.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)_object.validateOnly));
        } else if (_object.validateOnly) {
            throw new UnsupportedVersionException("Attempted to write a non-default validateOnly at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(CreateTopicsRequestData _object, short _version) {
        return CreateTopicsRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class CreateableTopicConfigJsonConverter {
        public static CreateTopicsRequestData.CreateableTopicConfig read(JsonNode _node, short _version) {
            CreateTopicsRequestData.CreateableTopicConfig _object = new CreateTopicsRequestData.CreateableTopicConfig();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreateableTopicConfig: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreateableTopicConfig expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _valueNode = _node.get("value");
            if (_valueNode == null) {
                throw new RuntimeException("CreateableTopicConfig: unable to locate field 'value', which is mandatory in version " + _version);
            }
            if (_valueNode.isNull()) {
                _object.value = null;
            } else {
                if (!_valueNode.isTextual()) {
                    throw new RuntimeException("CreateableTopicConfig expected a string type, but got " + _node.getNodeType());
                }
                _object.value = _valueNode.asText();
            }
            return _object;
        }

        public static JsonNode write(CreateTopicsRequestData.CreateableTopicConfig _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            if (_object.value == null) {
                _node.set("value", (JsonNode)NullNode.instance);
            } else {
                _node.set("value", (JsonNode)new TextNode(_object.value));
            }
            return _node;
        }

        public static JsonNode write(CreateTopicsRequestData.CreateableTopicConfig _object, short _version) {
            return CreateableTopicConfigJsonConverter.write(_object, _version, true);
        }
    }

    public static class CreatableTopicJsonConverter {
        public static CreateTopicsRequestData.CreatableTopic read(JsonNode _node, short _version) {
            CreateTopicsRequestData.CreateableTopicConfigCollection _collection;
            CreateTopicsRequestData.CreatableReplicaAssignmentCollection _collection2;
            CreateTopicsRequestData.CreatableTopic _object = new CreateTopicsRequestData.CreatableTopic();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreatableTopic expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _numPartitionsNode = _node.get("numPartitions");
            if (_numPartitionsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'numPartitions', which is mandatory in version " + _version);
            }
            _object.numPartitions = MessageUtil.jsonNodeToInt(_numPartitionsNode, "CreatableTopic");
            JsonNode _replicationFactorNode = _node.get("replicationFactor");
            if (_replicationFactorNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'replicationFactor', which is mandatory in version " + _version);
            }
            _object.replicationFactor = MessageUtil.jsonNodeToShort(_replicationFactorNode, "CreatableTopic");
            JsonNode _assignmentsNode = _node.get("assignments");
            if (_assignmentsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'assignments', which is mandatory in version " + _version);
            }
            if (!_assignmentsNode.isArray()) {
                throw new RuntimeException("CreatableTopic expected a JSON array, but got " + _node.getNodeType());
            }
            _object.assignments = _collection2 = new CreateTopicsRequestData.CreatableReplicaAssignmentCollection(_assignmentsNode.size());
            for (JsonNode _element : _assignmentsNode) {
                _collection2.add(CreatableReplicaAssignmentJsonConverter.read(_element, _version));
            }
            JsonNode _configsNode = _node.get("configs");
            if (_configsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'configs', which is mandatory in version " + _version);
            }
            if (!_configsNode.isArray()) {
                throw new RuntimeException("CreatableTopic expected a JSON array, but got " + _node.getNodeType());
            }
            _object.configs = _collection = new CreateTopicsRequestData.CreateableTopicConfigCollection(_configsNode.size());
            for (JsonNode _element : _configsNode) {
                _collection.add(CreateableTopicConfigJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("numPartitions", (JsonNode)new IntNode(_object.numPartitions));
            _node.set("replicationFactor", (JsonNode)new ShortNode(_object.replicationFactor));
            ArrayNode _assignmentsArray = new ArrayNode(JsonNodeFactory.instance);
            for (CreateTopicsRequestData.CreatableReplicaAssignment _element : _object.assignments) {
                _assignmentsArray.add(CreatableReplicaAssignmentJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("assignments", (JsonNode)_assignmentsArray);
            ArrayNode _configsArray = new ArrayNode(JsonNodeFactory.instance);
            for (CreateTopicsRequestData.CreateableTopicConfig _element : _object.configs) {
                _configsArray.add(CreateableTopicConfigJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("configs", (JsonNode)_configsArray);
            return _node;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableTopic _object, short _version) {
            return CreatableTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class CreatableReplicaAssignmentJsonConverter {
        public static CreateTopicsRequestData.CreatableReplicaAssignment read(JsonNode _node, short _version) {
            CreateTopicsRequestData.CreatableReplicaAssignment _object = new CreateTopicsRequestData.CreatableReplicaAssignment();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("CreatableReplicaAssignment: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "CreatableReplicaAssignment");
            JsonNode _brokerIdsNode = _node.get("brokerIds");
            if (_brokerIdsNode == null) {
                throw new RuntimeException("CreatableReplicaAssignment: unable to locate field 'brokerIds', which is mandatory in version " + _version);
            }
            if (!_brokerIdsNode.isArray()) {
                throw new RuntimeException("CreatableReplicaAssignment expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_brokerIdsNode.size());
            _object.brokerIds = _collection;
            for (JsonNode _element : _brokerIdsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "CreatableReplicaAssignment element"));
            }
            return _object;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableReplicaAssignment _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            ArrayNode _brokerIdsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.brokerIds) {
                _brokerIdsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("brokerIds", (JsonNode)_brokerIdsArray);
            return _node;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableReplicaAssignment _object, short _version) {
            return CreatableReplicaAssignmentJsonConverter.write(_object, _version, true);
        }
    }
}

