/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.server.policy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Configurable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.PolicyViolationException;

public interface CreateTopicPolicy
extends Configurable,
AutoCloseable {
    public void validate(RequestMetadata var1) throws PolicyViolationException;

    public static class RequestMetadata {
        private final String topic;
        private final Integer numPartitions;
        private final Short replicationFactor;
        private final Map<Integer, List<Integer>> replicasAssignments;
        private final Map<String, String> configs;

        public RequestMetadata(String topic, Integer numPartitions, Short replicationFactor, Map<Integer, List<Integer>> replicasAssignments, Map<String, String> configs) {
            this.topic = topic;
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
            this.replicasAssignments = replicasAssignments == null ? null : Collections.unmodifiableMap(replicasAssignments);
            this.configs = Collections.unmodifiableMap(configs);
        }

        public String topic() {
            return this.topic;
        }

        public Integer numPartitions() {
            return this.numPartitions;
        }

        public Short replicationFactor() {
            return this.replicationFactor;
        }

        public Map<Integer, List<Integer>> replicasAssignments() {
            return this.replicasAssignments;
        }

        public Map<String, String> configs() {
            return this.configs;
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.numPartitions, this.replicationFactor, this.replicasAssignments, this.configs);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestMetadata other = (RequestMetadata)o;
            return this.topic.equals(other.topic) && Objects.equals(this.numPartitions, other.numPartitions) && Objects.equals(this.replicationFactor, other.replicationFactor) && Objects.equals(this.replicasAssignments, other.replicasAssignments) && this.configs.equals(other.configs);
        }

        public String toString() {
            return "CreateTopicPolicy.RequestMetadata(topic=" + this.topic + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", replicasAssignments=" + this.replicasAssignments + ", configs=" + this.configs + ")";
        }
    }
}

