/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.kafka.sink.KafkaPartitioner;
import org.apache.flink.connector.kafka.source.KafkaSourceOptions;
import org.apache.flink.streaming.connectors.kafka.config.BoundedMode;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptionsUtil;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSource;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.streaming.util.upgrade.KafkaOptionUpgradableHelper;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.connector.OptionSnapshot;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.CannotMigrateException;
import org.apache.flink.table.factories.CannotSnapshotException;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.OptionUpgradableTableFactory;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KafkaDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory,
OptionUpgradableTableFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaDynamicTableFactory.class);
    private static final ConfigOption<String> SINK_SEMANTIC = ConfigOptions.key((String)"sink.semantic").stringType().noDefaultValue().withDescription("Optional semantic when committing.");
    public static final String IDENTIFIER = "kafka";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(KafkaConnectorOptions.KEY_FORMAT);
        options.add(KafkaConnectorOptions.KEY_FIELDS);
        options.add(KafkaConnectorOptions.KEY_FIELDS_PREFIX);
        options.add(KafkaConnectorOptions.VALUE_FIELDS_PREFIX);
        options.add(KafkaConnectorOptions.VALUE_FORMAT);
        options.add(KafkaConnectorOptions.VALUE_FIELDS_INCLUDE);
        options.add(KafkaConnectorOptions.TOPIC);
        options.add(KafkaConnectorOptions.TOPIC_PATTERN);
        options.add(KafkaConnectorOptions.PROPS_GROUP_ID);
        options.add(KafkaConnectorOptions.SCAN_STARTUP_MODE);
        options.add(KafkaConnectorOptions.SCAN_STARTUP_SPECIFIC_OFFSETS);
        options.add(KafkaConnectorOptions.SCAN_TOPIC_PARTITION_DISCOVERY);
        options.add(KafkaConnectorOptions.SCAN_STARTUP_TIMESTAMP_MILLIS);
        options.add(KafkaConnectorOptions.VERVERICA_START_TIME_MILLS);
        options.add(KafkaConnectorOptions.VERVERICA_OPTIONAL_START_TIME);
        options.add(KafkaConnectorOptions.VERVERICA_TIME_ZONE);
        options.add(KafkaConnectorOptions.SINK_PARTITIONER);
        options.add(KafkaConnectorOptions.SINK_PARALLELISM);
        options.add(KafkaConnectorOptions.DELIVERY_GUARANTEE);
        options.add(KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX);
        options.add(SINK_SEMANTIC);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_MODE);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_SPECIFIC_OFFSETS);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_TIMESTAMP_MILLIS);
        options.add(KafkaConnectorOptions.SCAN_CHECK_DUPLICATED_GROUP_ID);
        options.add(KafkaConnectorOptions.SCAN_HEADER_FILTER);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS, KafkaConnectorOptions.PROPS_GROUP_ID, KafkaConnectorOptions.TOPIC, KafkaConnectorOptions.TOPIC_PATTERN, KafkaConnectorOptions.SCAN_STARTUP_MODE, KafkaConnectorOptions.SCAN_STARTUP_SPECIFIC_OFFSETS, KafkaConnectorOptions.SCAN_TOPIC_PARTITION_DISCOVERY, KafkaConnectorOptions.SCAN_STARTUP_TIMESTAMP_MILLIS, KafkaConnectorOptions.SINK_PARTITIONER, KafkaConnectorOptions.SINK_PARALLELISM, KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX, KafkaConnectorOptions.SCAN_CHECK_DUPLICATED_GROUP_ID).collect(Collectors.toSet());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptionsFromCatalog = helper.getOptions();
        Preconditions.checkState((boolean)(tableOptionsFromCatalog instanceof Configuration), (Object)"Table options in catalog should be an instance of Configuration");
        Map<String, String> tableOptionsFromTableConfig = KafkaConnectorOptionsUtil.getTableOptionsFromTableConfig(context);
        HashMap<String, String> mergedTableOptions = new HashMap<String, String>(((Configuration)tableOptionsFromCatalog).toMap());
        mergedTableOptions.putAll(tableOptionsFromTableConfig);
        Configuration tableOptions = Configuration.fromMap(mergedTableOptions);
        Optional<DecodingFormat<DeserializationSchema<RowData>>> keyDecodingFormat = KafkaDynamicTableFactory.getKeyDecodingFormat(helper);
        DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat = KafkaDynamicTableFactory.getValueDecodingFormat(helper);
        helper.validateExcept(new String[]{"properties."});
        KafkaConnectorOptionsUtil.validateTableSourceOptions((ReadableConfig)tableOptions);
        this.validatePKConstraints(context.getCatalogTable().getSchema());
        KafkaConnectorOptionsUtil.StartupOptions startupOptions = KafkaConnectorOptionsUtil.getStartupOptions((ReadableConfig)tableOptions);
        KafkaConnectorOptionsUtil.BoundedOptions boundedOptions = KafkaConnectorOptionsUtil.getBoundedOptions((ReadableConfig)tableOptions);
        Properties properties = KafkaConnectorOptionsUtil.getKafkaProperties(context.getCatalogTable().getOptions());
        Duration partitionDiscoveryInterval = (Duration)tableOptions.get(KafkaConnectorOptions.SCAN_TOPIC_PARTITION_DISCOVERY);
        properties.setProperty(KafkaSourceOptions.PARTITION_DISCOVERY_INTERVAL_MS.key(), Long.toString(partitionDiscoveryInterval.toMillis()));
        properties.setProperty(KafkaSourceOptions.CHECK_DUPLICATED_GROUP_ID.key(), ((Boolean)tableOptions.get(KafkaConnectorOptions.SCAN_CHECK_DUPLICATED_GROUP_ID)).toString());
        DataType physicalDataType = context.getPhysicalRowDataType();
        int[] keyProjection = KafkaConnectorOptionsUtil.createKeyFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        int[] valueProjection = KafkaConnectorOptionsUtil.createValueFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        String valuePrefix = tableOptions.getOptional(KafkaConnectorOptions.VALUE_FIELDS_PREFIX).orElse(null);
        String headerFilterExpression = tableOptions.getOptional(KafkaConnectorOptions.SCAN_HEADER_FILTER).orElse(null);
        return this.createKafkaTableSource(context.getObjectIdentifier().toObjectPath(), physicalDataType, (DecodingFormat<DeserializationSchema<RowData>>)((DecodingFormat)keyDecodingFormat.orElse(null)), valueDecodingFormat, keyProjection, valueProjection, keyPrefix, valuePrefix, KafkaConnectorOptionsUtil.getTopics((ReadableConfig)tableOptions), KafkaConnectorOptionsUtil.getTopicPattern((ReadableConfig)tableOptions), properties, startupOptions.startupMode, startupOptions.specificOffsets, startupOptions.startupTimestampMillis, boundedOptions.boundedMode, boundedOptions.specificOffsets, boundedOptions.boundedTimestampMillis, context.getObjectIdentifier().asSummaryString(), headerFilterExpression);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)KafkaConnectorOptionsUtil.autoCompleteSchemaRegistrySubject(context));
        ReadableConfig tableOptionsFromCatalog = helper.getOptions();
        Preconditions.checkState((boolean)(tableOptionsFromCatalog instanceof Configuration), (Object)"Table options in catalog should be an instance of Configuration");
        Map<String, String> tableOptionsFromTableConfig = KafkaConnectorOptionsUtil.getTableOptionsFromTableConfig(context);
        HashMap<String, String> mergedTableOptions = new HashMap<String, String>(((Configuration)tableOptionsFromCatalog).toMap());
        mergedTableOptions.putAll(tableOptionsFromTableConfig);
        Configuration tableOptions = Configuration.fromMap(mergedTableOptions);
        Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat = KafkaDynamicTableFactory.getKeyEncodingFormat(helper);
        EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat = KafkaDynamicTableFactory.getValueEncodingFormat(helper);
        helper.validateExcept(new String[]{"properties."});
        DeliveryGuarantee deliveryGuarantee = KafkaDynamicTableFactory.validateDeprecatedSemantic((ReadableConfig)tableOptions);
        KafkaConnectorOptionsUtil.validateTableSinkOptions((ReadableConfig)tableOptions);
        this.validatePKConstraints(context.getCatalogTable().getSchema());
        KafkaConnectorOptionsUtil.validateDeliveryGuarantee((ReadableConfig)tableOptions);
        DataType physicalDataType = context.getPhysicalRowDataType();
        int[] keyProjection = KafkaConnectorOptionsUtil.createKeyFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        int[] valueProjection = KafkaConnectorOptionsUtil.createValueFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        String valuePrefix = tableOptions.getOptional(KafkaConnectorOptions.VALUE_FIELDS_PREFIX).orElse(null);
        Integer parallelism = tableOptions.getOptional(KafkaConnectorOptions.SINK_PARALLELISM).orElse(null);
        return this.createKafkaTableSink(physicalDataType, (EncodingFormat<SerializationSchema<RowData>>)((EncodingFormat)keyEncodingFormat.orElse(null)), valueEncodingFormat, keyProjection, valueProjection, keyPrefix, valuePrefix, KafkaConnectorOptionsUtil.getTopics((ReadableConfig)tableOptions), KafkaConnectorOptionsUtil.getTopicPattern((ReadableConfig)tableOptions), KafkaConnectorOptionsUtil.getKafkaProperties(context.getCatalogTable().getOptions()), KafkaConnectorOptionsUtil.getFlinkKafkaPartitioner((ReadableConfig)tableOptions, context.getClassLoader()).orElse(null), deliveryGuarantee, parallelism, (String)tableOptions.get(KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX), (KafkaConnectorOptions.ValueFieldsStrategy)((Object)tableOptions.get(KafkaConnectorOptions.VALUE_FIELDS_INCLUDE)), tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS).orElse(Collections.emptyList()));
    }

    private static Optional<DecodingFormat<DeserializationSchema<RowData>>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyDecodingFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        keyDecodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(KafkaConnectorOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyDecodingFormat;
    }

    private static Optional<EncodingFormat<SerializationSchema<RowData>>> getKeyEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyEncodingFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        keyEncodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(KafkaConnectorOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyEncodingFormat;
    }

    private static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT));
    }

    private static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT));
    }

    private static DeliveryGuarantee validateDeprecatedSemantic(ReadableConfig tableOptions) {
        if (tableOptions.getOptional(SINK_SEMANTIC).isPresent()) {
            LOG.warn("{} is deprecated and will be removed. Please use {} instead.", (Object)SINK_SEMANTIC.key(), (Object)KafkaConnectorOptions.DELIVERY_GUARANTEE.key());
            return DeliveryGuarantee.valueOf((String)((String)tableOptions.get(SINK_SEMANTIC)).toUpperCase().replace("-", "_"));
        }
        return (DeliveryGuarantee)tableOptions.get(KafkaConnectorOptions.DELIVERY_GUARANTEE);
    }

    protected KafkaDynamicSource createKafkaTableSource(ObjectPath tablePath, DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable String valuePrefix, @Nullable List<String> topics, @Nullable Pattern topicPattern, Properties properties, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis, BoundedMode boundedMode, Map<KafkaTopicPartition, Long> specificEndOffsets, long endTimestampMillis, String tableIdentifier, String headerFilterExpression) {
        return new KafkaDynamicSource(tablePath, physicalDataType, keyDecodingFormat, valueDecodingFormat, keyProjection, valueProjection, keyPrefix, valuePrefix, topics, topicPattern, properties, startupMode, specificStartupOffsets, startupTimestampMillis, boundedMode, specificEndOffsets, endTimestampMillis, false, tableIdentifier, headerFilterExpression);
    }

    protected KafkaDynamicSink createKafkaTableSink(DataType physicalDataType, @Nullable EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable String valuePrefix, @Nullable List<String> topics, @Nullable Pattern topicPattern, Properties properties, KafkaPartitioner<RowData> partitioner, DeliveryGuarantee deliveryGuarantee, Integer parallelism, @Nullable String transactionalIdPrefix, KafkaConnectorOptions.ValueFieldsStrategy valueFieldsStrategy, List<String> keyFields) {
        return new KafkaDynamicSink(physicalDataType, physicalDataType, keyEncodingFormat, valueEncodingFormat, keyProjection, valueProjection, keyPrefix, valuePrefix, topics, topicPattern, properties, partitioner, deliveryGuarantee, false, SinkBufferFlushMode.DISABLED, parallelism, transactionalIdPrefix, valueFieldsStrategy, keyFields);
    }

    private void validatePKConstraints(TableSchema schema) {
        List<String> usableMetadata = Arrays.asList(KafkaDynamicSource.ReadableMetadata.OFFSET.key, KafkaDynamicSource.ReadableMetadata.PARTITION.key);
        if (schema.getPrimaryKey().isPresent()) {
            ArrayList<TableColumn> metadataPKs = new ArrayList<TableColumn>();
            List columns = schema.getTableColumns();
            List primaryKeys = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
            for (String primaryKey : primaryKeys) {
                Optional<TableColumn> column = columns.stream().filter(c -> c.getName().equals(primaryKey)).findAny();
                if (column.isPresent()) {
                    if (!(column.get() instanceof TableColumn.MetadataColumn)) continue;
                    metadataPKs.add(column.get());
                    continue;
                }
                throw new ValidationException(String.format("The column %s in primary key can not be found in table schema.", primaryKey));
            }
            List metadataNamesInPK = metadataPKs.stream().map(pk -> {
                TableColumn.MetadataColumn metadataColumn = (TableColumn.MetadataColumn)pk;
                return metadataColumn.getMetadataAlias().orElse(metadataColumn.getName());
            }).collect(Collectors.toList());
            Collections.sort(metadataNamesInPK);
            if (!metadataPKs.isEmpty() && !usableMetadata.equals(metadataNamesInPK)) {
                throw new ValidationException(String.format("Only support to use primary key (`partition`, `offset`) in a Kafka table when using metadata as primary key. But primary key is [%s].", String.join((CharSequence)", ", primaryKeys)));
            }
        }
    }

    public OptionSnapshot snapshotOptions(OptionUpgradableTableFactory.UpgradeContext upgradeContext) throws CannotSnapshotException {
        return KafkaOptionUpgradableHelper.snapshotOptions(upgradeContext, this);
    }

    public Map<String, String> migrateOptions(OptionUpgradableTableFactory.UpgradeContext upgradeContext, OptionSnapshot optionSnapshot) throws CannotMigrateException {
        return KafkaOptionUpgradableHelper.migrateOptions(upgradeContext, optionSnapshot, this);
    }
}

