/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.streaming.connectors.kafka.table.DynamicEvolvingKafkaDeserializationSchema;
import org.apache.flink.util.Preconditions;

public class KafkaTableSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Pattern topicPattern;
    @Nullable
    private final List<String> topics;
    private final DynamicEvolvingKafkaDeserializationSchema deserializationSchema;

    public KafkaTableSpec(@Nullable Pattern topicPattern, @Nullable List<String> topics, DynamicEvolvingKafkaDeserializationSchema deserializationSchema) {
        Preconditions.checkArgument((topics != null && topicPattern == null || topics == null && topicPattern != null ? 1 : 0) != 0, (Object)"Either Topic or Topic Pattern must be set for source.");
        this.topicPattern = topicPattern;
        this.topics = topics;
        this.deserializationSchema = deserializationSchema;
    }

    @Nullable
    public List<String> getTopics() {
        return this.topics;
    }

    public DynamicEvolvingKafkaDeserializationSchema getDeserializationSchema() {
        return this.deserializationSchema;
    }

    @Nullable
    public Pattern getTopicPattern() {
        return this.topicPattern;
    }
}

