/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.kafka.table.DynamicEvolvingKafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.table.DynamicKafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSource;
import org.apache.flink.streaming.connectors.kafka.table.KafkaTableSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.SupportsEvolvingDecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.SourceRecord;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

public class KafkaTableSpecCreator {
    private final ObjectPath tablePathInFlink;
    @Nullable
    private final Pattern topicPattern;
    @Nullable
    private final List<String> topics;
    private final DataType physicalDataType;
    @Nullable
    private final transient DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat;
    private final transient DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat;
    private final int[] keyProjection;
    private final int[] valueProjection;
    @Nullable
    private final String keyPrefix;
    @Nullable
    private final String valuePrefix;
    private final List<String> metadataKeys;
    private final DataType producedDataType;

    public KafkaTableSpecCreator(ObjectPath tablePathInFlink, @Nullable Pattern topicPattern, @Nullable List<String> topics, List<String> metadataKeys, DataType physicalDataType, DataType producedDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable String valuePrefix) {
        Preconditions.checkArgument((topics != null && topicPattern == null || topics == null && topicPattern != null ? 1 : 0) != 0, (Object)"Either Topic or Topic Pattern must be set for source.");
        this.tablePathInFlink = tablePathInFlink;
        this.topicPattern = topicPattern;
        this.topics = topics;
        this.metadataKeys = metadataKeys;
        this.physicalDataType = physicalDataType;
        this.producedDataType = producedDataType;
        this.keyDecodingFormat = keyDecodingFormat;
        this.valueDecodingFormat = valueDecodingFormat;
        this.keyProjection = keyProjection;
        this.valueProjection = valueProjection;
        this.keyPrefix = keyPrefix;
        this.valuePrefix = valuePrefix;
    }

    public KafkaTableSpec create(ScanTableSource.ScanContext context) {
        DeserializationSchema<RowData> keyDeserialization = this.createDeserialization((DynamicTableSource.Context)context, this.physicalDataType, this.keyDecodingFormat, this.keyProjection, this.keyPrefix);
        DeserializationSchema<SourceRecord> valueDeserialization = this.createEvolvingDeserialization((DynamicTableSource.Context)context, this.physicalDataType, this.valueDecodingFormat, this.valueProjection, this.valuePrefix);
        DynamicKafkaDeserializationSchema.MetadataConverter[] metadataConverters = this.getMetadataConverters(this.metadataKeys);
        DynamicEvolvingKafkaDeserializationSchema dynamicEvolvingKafkaDeserializationSchema = new DynamicEvolvingKafkaDeserializationSchema(keyDeserialization, valueDeserialization, metadataConverters, this.tablePathInFlink, this.getKeyType(this.physicalDataType, this.keyProjection), this.getMetadataType(this.physicalDataType, this.producedDataType), this.valuePrefix, (TypeInformation<SourceRecord>)context.getEvolvingSourceTypeInfo());
        return new KafkaTableSpec(this.topicPattern, this.topics, dynamicEvolvingKafkaDeserializationSchema);
    }

    @Nullable
    private DeserializationSchema<RowData> createDeserialization(DynamicTableSource.Context context, DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = Projection.of((int[])projection).project(physicalDataType);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return (DeserializationSchema)format.createRuntimeDecoder(context, physicalFormatDataType);
    }

    private DeserializationSchema<SourceRecord> createEvolvingDeserialization(DynamicTableSource.Context context, DataType physicalDataType, DecodingFormat<DeserializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        DataType physicalFormatDataType = Projection.of((int[])projection).project(physicalDataType);
        Preconditions.checkArgument((boolean)(format instanceof SupportsEvolvingDecodingFormat), (Object)String.format("The specified value format %s doesn't support to evolve the schema.", format.getClass().getName()));
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return ((SupportsEvolvingDecodingFormat)format).createEvolvingRuntimeDecodingFormat(context, physicalFormatDataType);
    }

    @Nullable
    public List<String> getTopics() {
        return this.topics != null ? Collections.unmodifiableList(this.topics) : this.topics;
    }

    public ObjectPath getTablePathInFlink() {
        return this.tablePathInFlink;
    }

    public KafkaTableSpecCreator copy(List<String> metadataKeys, DataType producedDataType) {
        return new KafkaTableSpecCreator(this.tablePathInFlink, this.topicPattern, this.topics, metadataKeys, this.physicalDataType, producedDataType, this.keyDecodingFormat, this.valueDecodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.valuePrefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaTableSpecCreator)) {
            return false;
        }
        KafkaTableSpecCreator that = (KafkaTableSpecCreator)o;
        return this.getTablePathInFlink().equals((Object)that.getTablePathInFlink()) && Objects.equals(String.valueOf(this.topicPattern), String.valueOf(that.topicPattern)) && Objects.equals(this.topics, that.topics) && this.physicalDataType.equals((Object)that.physicalDataType) && Objects.equals(this.keyDecodingFormat, that.keyDecodingFormat) && this.valueDecodingFormat.equals(that.valueDecodingFormat) && Arrays.equals(this.keyProjection, that.keyProjection) && Arrays.equals(this.valueProjection, that.valueProjection) && Objects.equals(this.keyPrefix, that.keyPrefix) && Objects.equals(this.valuePrefix, that.valuePrefix) && this.metadataKeys.equals(that.metadataKeys) && this.producedDataType.equals((Object)that.producedDataType);
    }

    public int hashCode() {
        int result = Objects.hash(this.getTablePathInFlink(), String.valueOf(this.topicPattern), this.topics, this.physicalDataType, this.keyDecodingFormat, this.valueDecodingFormat, this.keyPrefix, this.valuePrefix, this.metadataKeys, this.producedDataType);
        result = 31 * result + Arrays.hashCode(this.keyProjection);
        result = 31 * result + Arrays.hashCode(this.valueProjection);
        return result;
    }

    private RowType getKeyType(DataType physicalDataType, int[] keyProjection) {
        return (RowType)Projection.of((int[])keyProjection).project(physicalDataType).getLogicalType();
    }

    private RowType getMetadataType(DataType physicalDataType, DataType producedDataType) {
        DataType metadataType = Projection.of((int[])IntStream.range(physicalDataType.getChildren().size(), producedDataType.getChildren().size()).toArray()).project(producedDataType);
        return (RowType)metadataType.getLogicalType();
    }

    private DynamicKafkaDeserializationSchema.MetadataConverter[] getMetadataConverters(List<String> metadataKeys) {
        return (DynamicKafkaDeserializationSchema.MetadataConverter[])metadataKeys.stream().map(k -> Stream.of(KafkaDynamicSource.ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).map(m -> m.converter).toArray(DynamicKafkaDeserializationSchema.MetadataConverter[]::new);
    }
}

