/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptionsUtil;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSource;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicTableFactory;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.streaming.util.upgrade.KafkaOptionUpgradableHelper;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.OptionSnapshot;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.format.SupportsEvolvingEncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.SchemaAwareSinkRecord;
import org.apache.flink.table.factories.CannotMigrateException;
import org.apache.flink.table.factories.CannotSnapshotException;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.OptionUpgradableTableFactory;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertKafkaDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory,
OptionUpgradableTableFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaDynamicTableFactory.class);
    public static final String IDENTIFIER = "upsert-kafka";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS);
        options.add(KafkaConnectorOptions.KEY_FORMAT);
        options.add(KafkaConnectorOptions.VALUE_FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(KafkaConnectorOptions.TOPIC);
        options.add(KafkaConnectorOptions.TOPIC_PATTERN);
        options.add(KafkaConnectorOptions.KEY_FIELDS_PREFIX);
        options.add(KafkaConnectorOptions.VALUE_FIELDS_PREFIX);
        options.add(KafkaConnectorOptions.VALUE_FIELDS_INCLUDE);
        options.add(KafkaConnectorOptions.SINK_PARALLELISM);
        options.add(KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        options.add(KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_MODE);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_SPECIFIC_OFFSETS);
        options.add(KafkaConnectorOptions.SCAN_BOUNDED_TIMESTAMP_MILLIS);
        options.add(KafkaConnectorOptions.DELIVERY_GUARANTEE);
        options.add(KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(KafkaConnectorOptions.DELIVERY_GUARANTEE, KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX).collect(Collectors.toSet());
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptionsFromCatalog = helper.getOptions();
        Preconditions.checkState((boolean)(tableOptionsFromCatalog instanceof Configuration), (Object)"Table options in catalog should be an instance of Configuration");
        Configuration tableOptions = this.getUpsertKafkaTableOption(context, (Configuration)tableOptionsFromCatalog);
        DecodingFormat keyDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        DecodingFormat valueDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties."});
        UpsertKafkaDynamicTableFactory.validateSource((ReadableConfig)tableOptions, (Format)keyDecodingFormat, (Format)valueDecodingFormat, context.getCatalogTable().getResolvedSchema());
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections((ReadableConfig)tableOptions, context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        String valuePrefix = tableOptions.getOptional(KafkaConnectorOptions.VALUE_FIELDS_PREFIX).orElse(null);
        Properties properties = KafkaConnectorOptionsUtil.getKafkaProperties(context.getCatalogTable().getOptions());
        StartupMode earliest = StartupMode.EARLIEST;
        KafkaConnectorOptionsUtil.BoundedOptions boundedOptions = KafkaConnectorOptionsUtil.getBoundedOptions((ReadableConfig)tableOptions);
        String headerFilterExpression = tableOptions.getOptional(KafkaConnectorOptions.SCAN_HEADER_FILTER).orElse(null);
        return new KafkaDynamicSource(context.getObjectIdentifier().toObjectPath(), context.getPhysicalRowDataType(), (DecodingFormat<DeserializationSchema<RowData>>)keyDecodingFormat, new DecodingFormatWrapper((DecodingFormat<DeserializationSchema<RowData>>)valueDecodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, valuePrefix, KafkaConnectorOptionsUtil.getTopics((ReadableConfig)tableOptions), KafkaConnectorOptionsUtil.getTopicPattern((ReadableConfig)tableOptions), properties, earliest, Collections.emptyMap(), 0L, boundedOptions.boundedMode, boundedOptions.specificOffsets, boundedOptions.boundedTimestampMillis, true, context.getObjectIdentifier().asSummaryString(), headerFilterExpression);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)KafkaConnectorOptionsUtil.autoCompleteSchemaRegistrySubject(context));
        ReadableConfig tableOptionsFromCatalog = helper.getOptions();
        Preconditions.checkState((boolean)(tableOptionsFromCatalog instanceof Configuration), (Object)"Table options in catalog should be an instance of Configuration");
        Configuration tableOptions = this.getUpsertKafkaTableOption(context, (Configuration)tableOptionsFromCatalog);
        EncodingFormat keyEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.KEY_FORMAT);
        EncodingFormat valueEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, KafkaConnectorOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties."});
        UpsertKafkaDynamicTableFactory.validateSink((ReadableConfig)tableOptions, (Format)keyEncodingFormat, (Format)valueEncodingFormat, context.getCatalogTable().getResolvedSchema());
        KafkaConnectorOptionsUtil.validateDeliveryGuarantee((ReadableConfig)tableOptions);
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections((ReadableConfig)tableOptions, context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS_PREFIX).orElse(null);
        String valuePrefix = tableOptions.getOptional(KafkaConnectorOptions.VALUE_FIELDS_PREFIX).orElse(null);
        Properties properties = KafkaConnectorOptionsUtil.getKafkaProperties(context.getCatalogTable().getOptions());
        Integer parallelism = (Integer)tableOptions.get(KafkaConnectorOptions.SINK_PARALLELISM);
        int batchSize = (Integer)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        Duration batchInterval = (Duration)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        SinkBufferFlushMode flushMode = new SinkBufferFlushMode(batchSize, batchInterval.toMillis());
        return new KafkaDynamicSink(context.getPhysicalRowDataType(), context.getPhysicalRowDataType(), (EncodingFormat<SerializationSchema<RowData>>)keyEncodingFormat, new EncodingFormatWrapper((EncodingFormat<SerializationSchema<RowData>>)valueEncodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, valuePrefix, KafkaConnectorOptionsUtil.getTopics((ReadableConfig)tableOptions), KafkaConnectorOptionsUtil.getTopicPattern((ReadableConfig)tableOptions), properties, null, (DeliveryGuarantee)tableOptions.get(KafkaConnectorOptions.DELIVERY_GUARANTEE), true, flushMode, parallelism, (String)tableOptions.get(KafkaConnectorOptions.TRANSACTIONAL_ID_PREFIX), (KafkaConnectorOptions.ValueFieldsStrategy)((Object)tableOptions.get(KafkaConnectorOptions.VALUE_FIELDS_INCLUDE)), tableOptions.getOptional(KafkaConnectorOptions.KEY_FIELDS).orElse(Collections.emptyList()));
    }

    private Configuration getUpsertKafkaTableOption(DynamicTableFactory.Context context, Configuration tableOptionsFromCatalog) {
        Map<String, String> tableOptionsFromTableConfig = KafkaConnectorOptionsUtil.getTableOptionsFromTableConfig(context);
        HashMap<String, String> mergedTableOptions = new HashMap<String, String>(tableOptionsFromCatalog.toMap());
        mergedTableOptions.putAll(tableOptionsFromTableConfig);
        UpsertKafkaDynamicTableFactory.validatePKConstraints(context.getCatalogTable().getResolvedSchema());
        List keyFields = ((UniqueConstraint)context.getCatalogTable().getResolvedSchema().getPrimaryKey().get()).getColumns();
        Configuration finalConfig = Configuration.fromMap(mergedTableOptions);
        finalConfig.set(KafkaConnectorOptions.KEY_FIELDS, (Object)keyFields);
        return finalConfig;
    }

    private Tuple2<int[], int[]> createKeyValueProjections(ReadableConfig tableOptions, ResolvedCatalogTable catalogTable) {
        ResolvedSchema schema = catalogTable.getResolvedSchema();
        DataType physicalDataType = schema.toPhysicalRowDataType();
        return UpsertKafkaDynamicTableFactory.createKeyValueProjections(tableOptions, physicalDataType);
    }

    public static Tuple2<int[], int[]> createKeyValueProjections(ReadableConfig tableOptions, DataType physicalDataType) {
        int[] keyProjection = KafkaConnectorOptionsUtil.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = KafkaConnectorOptionsUtil.createValueFormatProjection(tableOptions, physicalDataType);
        return Tuple2.of((Object)keyProjection, (Object)valueProjection);
    }

    private static void validateSource(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, ResolvedSchema schema) {
        KafkaConnectorOptionsUtil.validateScanBoundedMode(tableOptions);
        UpsertKafkaDynamicTableFactory.validateFormat(keyFormat, valueFormat, tableOptions);
        UpsertKafkaDynamicTableFactory.validatePKConstraints(schema);
    }

    private static void validateSink(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, ResolvedSchema schema) {
        UpsertKafkaDynamicTableFactory.validateFormat(keyFormat, valueFormat, tableOptions);
        UpsertKafkaDynamicTableFactory.validatePKConstraints(schema);
        UpsertKafkaDynamicTableFactory.validateSinkBufferFlush(tableOptions);
    }

    private static void validateFormat(Format keyFormat, Format valueFormat, ReadableConfig tableOptions) {
        if (!keyFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(KafkaConnectorOptions.KEY_FORMAT);
            throw new ValidationException(String.format("'upsert-kafka' connector doesn't support '%s' as key format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
        if (!valueFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(KafkaConnectorOptions.VALUE_FORMAT);
            throw new ValidationException(String.format("'upsert-kafka' connector doesn't support '%s' as value format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
    }

    private static void validatePKConstraints(ResolvedSchema schema) {
        if (schema.getPrimaryKeyIndexes().length == 0) {
            throw new ValidationException("'upsert-kafka' tables require to define a PRIMARY KEY constraint. The PRIMARY KEY specifies which columns should be read from or write to the Kafka message key. The PRIMARY KEY also defines records in the 'upsert-kafka' table should update or delete on which keys.");
        }
        List columns = schema.getColumns();
        for (String primaryKey : ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns()) {
            Optional<Column> column = columns.stream().filter(c -> c.getName().equals(primaryKey)).findAny();
            if (column.isPresent()) {
                if (!(column.get() instanceof Column.MetadataColumn)) continue;
                throw new ValidationException(String.format("The PRIMARY KEY constraint in 'upsert-kafka' tables must not contain metadata. But %s is a metadata column.", primaryKey));
            }
            throw new ValidationException(String.format("The column %s in primary key can not be found in table schema.", primaryKey));
        }
    }

    private static void validateSinkBufferFlush(ReadableConfig tableOptions) {
        int flushMaxRows = (Integer)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        long flushIntervalMs = ((Duration)tableOptions.get(KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL)).toMillis();
        if (flushMaxRows > 0 && flushIntervalMs > 0L) {
            return;
        }
        if (flushMaxRows <= 0 && flushIntervalMs <= 0L) {
            return;
        }
        throw new ValidationException(String.format("'%s' and '%s' must be set to be greater than zero together to enable sink buffer flushing.", KafkaConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS.key(), KafkaConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL.key()));
    }

    public OptionSnapshot snapshotOptions(OptionUpgradableTableFactory.UpgradeContext upgradeContext) throws CannotSnapshotException {
        return KafkaOptionUpgradableHelper.snapshotOptions(upgradeContext, this);
    }

    public Map<String, String> migrateOptions(OptionUpgradableTableFactory.UpgradeContext upgradeContext, OptionSnapshot optionSnapshot) throws CannotMigrateException {
        return KafkaOptionUpgradableHelper.migrateOptions(upgradeContext, optionSnapshot, this);
    }

    protected static class EncodingFormatWrapper
    implements EncodingFormat<SerializationSchema<RowData>>,
    SupportsEvolvingEncodingFormat<SchemaAwareSinkRecord> {
        private final EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat;
        public static final ChangelogMode SINK_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();

        public EncodingFormatWrapper(EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat) {
            this.innerEncodingFormat = innerEncodingFormat;
        }

        public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
            return (SerializationSchema)this.innerEncodingFormat.createRuntimeEncoder(context, consumedDataType);
        }

        public SerializationSchema<SchemaAwareSinkRecord> createEvolvingRuntimeEncoder(DynamicTableSink.Context context) {
            if (this.innerEncodingFormat instanceof SupportsEvolvingEncodingFormat) {
                return ((SupportsEvolvingEncodingFormat)this.innerEncodingFormat).createEvolvingRuntimeEncoder(context);
            }
            throw new UnsupportedOperationException(String.format("Can not create evolving serialization schema due to EncodingFormat %s doesn't implement SupportsEvolvingEncodingFormat.", this.innerEncodingFormat));
        }

        public ChangelogMode getChangelogMode() {
            return SINK_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EncodingFormatWrapper that = (EncodingFormatWrapper)obj;
            return Objects.equals(this.innerEncodingFormat, that.innerEncodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerEncodingFormat);
        }
    }

    protected static class DecodingFormatWrapper
    implements DecodingFormat<DeserializationSchema<RowData>> {
        private final DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat;
        private static final ChangelogMode SOURCE_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();

        public DecodingFormatWrapper(DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat) {
            this.innerDecodingFormat = innerDecodingFormat;
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
            return (DeserializationSchema)this.innerDecodingFormat.createRuntimeDecoder(context, producedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SOURCE_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DecodingFormatWrapper that = (DecodingFormatWrapper)obj;
            return Objects.equals(this.innerDecodingFormat, that.innerDecodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerDecodingFormat);
        }
    }
}

