/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.cache.AllCache;
import com.alibaba.ververica.connectors.common.dim.cache.BinaryAllCache;
import com.alibaba.ververica.connectors.common.dim.cache.BinaryListAllCache;
import com.alibaba.ververica.connectors.common.dim.cache.Cache;
import com.alibaba.ververica.connectors.common.dim.cache.CacheStrategy;
import com.alibaba.ververica.connectors.common.dim.cache.LRUCache;
import com.alibaba.ververica.connectors.common.dim.cache.ListAllCache;
import com.alibaba.ververica.connectors.common.dim.cache.NoneCache;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactory<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheFactory.class);
    private Map<String, Cache<K, V>> cacheMap = new HashMap<String, Cache<K, V>>();
    private static CacheFactory instance;

    private CacheFactory() {
    }

    public static synchronized <K, V> CacheFactory<K, V> getInstance() {
        if (instance == null) {
            instance = new CacheFactory<K, V>();
        }
        return instance;
    }

    public synchronized Cache<K, V> getCache(String tableName, CacheStrategy cacheStrategy, boolean lookupByUniqueKey) {
        return this.getCache(tableName, cacheStrategy, lookupByUniqueKey, null, null);
    }

    public synchronized Cache<K, V> getCache(String tableName, CacheStrategy cacheStrategy, boolean lookupByUniqueKey, RowDataSerializer keySer, RowDataSerializer valSer) {
        if (cacheStrategy.isNoCache()) {
            return this.createNoneCache(tableName);
        }
        if (cacheStrategy.isAllCache()) {
            return this.createAllCache(tableName, cacheStrategy, lookupByUniqueKey, keySer, valSer);
        }
        if (cacheStrategy.isNeverExpired()) {
            return this.createLRUCache(tableName, cacheStrategy.getSize(), cacheStrategy.isRecordingStats());
        }
        return this.createLRUCache(tableName, cacheStrategy.getSize(), cacheStrategy.getTtlMs(), cacheStrategy.isRecordingStats());
    }

    public synchronized void removeCache(String tableName) {
        this.cacheMap.remove(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Map<String, Cache<K, V>> map = this.cacheMap;
        synchronized (map) {
            if (null != this.cacheMap && this.cacheMap.size() > 0) {
                this.cacheMap.clear();
            }
        }
    }

    private Cache<K, V> createNoneCache(String tableName) {
        Cache<K, V> cache = this.cacheMap.get(tableName);
        if (cache == null) {
            cache = new NoneCache();
            this.cacheMap.put(tableName, cache);
            LOG.info("Create None cache for table: " + tableName);
        }
        return cache;
    }

    private Cache<K, V> createAllCache(String tableName, CacheStrategy cacheStrategy, boolean lookupByUniqueKey, RowDataSerializer keySer, RowDataSerializer valSer) {
        AllCache cache = this.cacheMap.get(tableName);
        if (cache == null) {
            cache = lookupByUniqueKey ? (cacheStrategy.isBinaryCacheEnabled() ? new BinaryAllCache(keySer, valSer) : new AllCache()) : (cacheStrategy.isBinaryCacheEnabled() ? new BinaryListAllCache(keySer, valSer) : new ListAllCache());
            this.cacheMap.put(tableName, cache);
            LOG.info("Create AllCache, tableName=" + tableName + ", reloadInterval=" + cacheStrategy.getTtlMs() + "ms.");
        } else {
            LOG.info("Get AllCache from factory, tableName=" + tableName + ", reloadInterval=" + cacheStrategy.getTtlMs() + "ms.");
        }
        return cache;
    }

    private Cache<K, V> createLRUCache(String tableName, long cacheSize, boolean isRecordingStats) {
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0, (Object)"cache must be greater than zero");
        Cache<K, V> lruCache = this.cacheMap.get(tableName);
        if (lruCache == null) {
            lruCache = new LRUCache(cacheSize, isRecordingStats);
            this.cacheMap.put(tableName, lruCache);
            LOG.info("Create LRUCache, tableName=" + tableName + ", cacheSize=" + cacheSize + ", never expired.");
        } else {
            LOG.info("Get LRUCache from factory, tableName=" + tableName + ", cacheSize=" + cacheSize + ", never expired.");
        }
        return lruCache;
    }

    private Cache<K, V> createLRUCache(String tableName, long cacheSize, long cacheExpireTime, boolean isRecordingStats) {
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0, (Object)"cache size must be greater than zero");
        Preconditions.checkArgument((cacheExpireTime > 0L ? 1 : 0) != 0, (Object)"cache expire time must be greater than zero");
        Cache<K, V> lruCache = this.cacheMap.get(tableName);
        if (lruCache == null) {
            lruCache = new LRUCache(cacheSize, cacheExpireTime, isRecordingStats);
            this.cacheMap.put(tableName, lruCache);
            LOG.info("Create LRUCache, tableName=" + tableName + ", cacheSize=" + cacheSize + ", expireTime=" + cacheExpireTime);
        } else {
            LOG.info("Get LRUCache from factory, tableName=" + tableName + ", cacheSize=" + cacheSize + ", expireTime=" + cacheExpireTime);
        }
        return lruCache;
    }
}

