/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.sink;

import com.alibaba.ververica.connectors.common.MetricUtils;
import java.io.IOException;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.types.Row;

public abstract class TupleRichOutputFormat
extends RichOutputFormat<Tuple2<Boolean, Row>> {
    private Meter sinkOutTps;
    private Counter delCounter;

    public void open(int taskNumber, int numTasks) throws IOException {
        this.sinkOutTps = MetricUtils.registerNumRecordsOutRate(this.getRuntimeContext());
        this.delCounter = MetricUtils.registerSinkDeleteCounter(this.getRuntimeContext());
    }

    public void writeRecord(Tuple2<Boolean, Row> cRow) throws IOException {
        this.sinkOutTps.markEvent();
        if (((Boolean)cRow.f0).booleanValue()) {
            this.writeAddRecord(Row.copy((Row)((Row)cRow.f1)));
        } else {
            this.writeDeleteRecord(Row.copy((Row)((Row)cRow.f1)));
            this.delCounter.inc();
        }
    }

    public abstract void writeAddRecord(Row var1) throws IOException;

    public abstract void writeDeleteRecord(Row var1) throws IOException;

    public abstract String getName();
}

