/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.sink;

import com.alibaba.ververica.connectors.common.MetricUtils;
import java.io.IOException;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;

public abstract class TupleRichOutputFormatRowData
extends RichOutputFormat<RowData> {
    private Meter sinkOutTps;
    private Counter delCounter;

    public void open(int taskNumber, int numTasks) throws IOException {
        this.sinkOutTps = MetricUtils.registerNumRecordsOutRate(this.getRuntimeContext());
        this.delCounter = MetricUtils.registerSinkDeleteCounter(this.getRuntimeContext());
    }

    public void writeRecord(RowData cRow) throws IOException {
        this.sinkOutTps.markEvent();
        if (cRow.getRowKind() == RowKind.INSERT) {
            this.writeAddRecord(cRow);
        } else {
            this.writeDeleteRecord(cRow);
            this.delCounter.inc();
        }
    }

    public abstract void writeAddRecord(RowData var1) throws IOException;

    public abstract void writeDeleteRecord(RowData var1) throws IOException;

    public abstract String getName();
}

