/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

public class ByteArray {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private int hash;

    public ByteArray(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteArray(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteArray)) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[this.offset + i] == other.bytes[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0 && this.length > 0) {
            for (int i = 0; i < this.length; ++i) {
                h2 = 31 * h2 + this.bytes[this.offset + i];
            }
            this.hash = h2;
        }
        return h2;
    }
}

