/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.planner;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.classloading.ComponentClassLoader;
import org.apache.flink.util.IOUtils;

public class PlannerDelegateLoader {
    static final String FLINK_TABLE_PLANNER_FAT_JAR = "flink-table-planner.jar";
    static final String VERVERICA_CONNECTOR_PLANNER_DELEGATE_FAT_JAR = "ververica-connector-planner-delegate.jar";
    private static final String[] OWNER_CLASSPATH = (String[])Stream.concat(Arrays.stream(CoreOptions.PARENT_FIRST_LOGGING_PATTERNS), Stream.of("org.codehaus.janino", "org.codehaus.commons", "org.apache.commons.lang3")).toArray(String[]::new);
    private static final String[] COMPONENT_CLASSPATH = new String[]{"org.apache.flink", "com.alibaba.ververica.connectors"};
    private static final Map<String, String> KNOWN_MODULE_ASSOCIATIONS = new HashMap<String, String>();
    private final ClassLoader submoduleClassLoader;

    private PlannerDelegateLoader() {
        try {
            ClassLoader flinkClassLoader = PlannerDelegateLoader.class.getClassLoader();
            Path tmpDirectory = Paths.get(ConfigurationUtils.parseTempDirectories((Configuration)new Configuration())[0], new String[0]);
            Files.createDirectories(tmpDirectory, new FileAttribute[0]);
            Path plannerJar = this.extractResource(FLINK_TABLE_PLANNER_FAT_JAR, flinkClassLoader, tmpDirectory, "Flink table planner could not be found.\nIf you're running a test, please add the following dependency to your pom.xml.\n<dependency>\n    <groupId>org.apache.flink</groupId>\n    <artifactId>flink-table-planner-loader</artifactId>\n    <version>${flink.version}</version>\n    <scope>test</scope>\n</dependency>");
            Path delegateJar = this.extractResource(VERVERICA_CONNECTOR_PLANNER_DELEGATE_FAT_JAR, flinkClassLoader, tmpDirectory, "Flink table store codegen could not be found.\nIf you're running a test, please make sure you've built the ververica connector planner modules by running\ncd ververica-connector-planner && mvn clean package -DskipTests");
            this.submoduleClassLoader = new ComponentClassLoader(new URL[]{plannerJar.toUri().toURL(), delegateJar.toUri().toURL()}, flinkClassLoader, OWNER_CLASSPATH, COMPONENT_CLASSPATH, KNOWN_MODULE_ASSOCIATIONS);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize the table planner components loader.", e);
        }
    }

    private Path extractResource(String resourceName, ClassLoader flinkClassLoader, Path tmpDirectory, String errorMessage) throws IOException {
        CharSequence[] splitName = resourceName.split("\\.");
        splitName[0] = splitName[0] + "_" + UUID.randomUUID();
        Path tempFile = Files.createFile(tmpDirectory.resolve(String.join((CharSequence)".", splitName)), new FileAttribute[0]);
        InputStream resourceStream = flinkClassLoader.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new RuntimeException(errorMessage);
        }
        IOUtils.copyBytes((InputStream)resourceStream, (OutputStream)Files.newOutputStream(tempFile, new OpenOption[0]));
        return tempFile;
    }

    private static PlannerDelegateLoader getInstance() {
        return PlannerDelegateLoaderHolder.INSTANCE;
    }

    public static <T> T discover(Class<T> clazz) {
        return (T)PlannerDelegateLoader.discoverWithContextClassLoader(clazz).orElseGet(() -> PlannerDelegateLoader.getInstance().discoverWithSubmoduleClassLoader(clazz));
    }

    private static <T> Optional<T> discoverWithContextClassLoader(Class<T> clazz) {
        ArrayList results = new ArrayList();
        ServiceLoader.load(clazz, Thread.currentThread().getContextClassLoader()).iterator().forEachRemaining(results::add);
        return results.stream().findFirst();
    }

    private <T> T discoverWithSubmoduleClassLoader(Class<T> clazz) {
        ArrayList results = new ArrayList();
        ServiceLoader.load(clazz, this.submoduleClassLoader).iterator().forEachRemaining(results::add);
        if (results.size() != 1) {
            throw new RuntimeException("Found " + results.size() + " classes implementing " + clazz.getName() + ". They are:\n" + results.stream().map(t -> t.getClass().getName()).collect(Collectors.joining("\n")));
        }
        return (T)results.get(0);
    }

    static {
        KNOWN_MODULE_ASSOCIATIONS.put("org.apache.flink.table.runtime", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.apache.flink.formats.raw", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.codehaus.janino", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.codehaus.commons", "flink-table-runtime");
        KNOWN_MODULE_ASSOCIATIONS.put("org.apache.flink.table.shaded.com.jayway", "flink-table-runtime");
    }

    private static class PlannerDelegateLoaderHolder {
        private static final PlannerDelegateLoader INSTANCE = new PlannerDelegateLoader();

        private PlannerDelegateLoaderHolder() {
        }
    }
}

