/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls;

import com.alibaba.ververica.connectors.common.table.VervericaTableOptions;
import com.alibaba.ververica.connectors.common.util.ContextUtil;
import com.alibaba.ververica.connectors.sls.SLSAccessInfo;
import com.alibaba.ververica.connectors.sls.SLSOptions;
import com.alibaba.ververica.connectors.sls.SLSUtils;
import com.alibaba.ververica.connectors.sls.sink.SLSDynamicTableSink;
import com.alibaba.ververica.connectors.sls.source.SLSDynamicTableSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;

public class SLSDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        DynamicTableFactory.Context mergedContext = ContextUtil.mergeTableOptionsFromTableConfig(context);
        DynamicTableFactory.Context normalizedContext = ContextUtil.normalizeContext((DynamicTableFactory)this, mergedContext);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)normalizedContext);
        helper.validate();
        Map rawProperties = normalizedContext.getCatalogTable().getOptions();
        HashMap lowerCaseProperties = new HashMap();
        Configuration properties = new Configuration();
        for (String key : rawProperties.keySet()) {
            lowerCaseProperties.put(key.toLowerCase(), rawProperties.get(key));
            properties.setString(key.toLowerCase(), (String)rawProperties.get(key));
        }
        Long startTimeMs = (Long)properties.get(VervericaTableOptions.START_TIME_MILLS);
        String tableName = (String)properties.get(VervericaTableOptions.TABLE_NAME);
        String startDateTime = (String)properties.get(VervericaTableOptions.OPTIONAL_START_TIME);
        String stopDateTime = (String)properties.get(SLSOptions.STOP_TIME);
        String timeZone = (String)properties.get(SLSOptions.OPTIONAL_TIME_ZONE);
        boolean exitAfterReadFinish = properties.getBoolean(VervericaTableOptions.OPTIONAL_EXIT_AFTER_FINISH);
        int startInSec = startTimeMs != null && startTimeMs > 0L ? (int)(startTimeMs / 1000L) : SLSUtils.getStartTimeInSecs(startDateTime, timeZone);
        int stopInSec = SLSUtils.getStopTimeInSecs(stopDateTime, timeZone);
        SLSAccessInfo accessInfo = SLSUtils.parseConsumerConfig(properties);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)normalizedContext.getCatalogTable().getSchema());
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(lowerCaseProperties);
        descriptorProperties.putTableSchema("schema", normalizedContext.getCatalogTable().getSchema());
        return new SLSDynamicTableSource(tableName, startInSec, stopInSec, accessInfo, physicalSchema, descriptorProperties, exitAfterReadFinish);
    }

    public String factoryIdentifier() {
        return "sls";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return SLSOptions.SOURCE_REQUIRED_OPTIONS;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return SLSOptions.SOURCE_OPTIONAL_OPTIONS;
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        DynamicTableFactory.Context normalizedContext = ContextUtil.normalizeContext((DynamicTableFactory)this, context);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)normalizedContext);
        helper.validate();
        ReadableConfig options = helper.getOptions();
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)normalizedContext.getCatalogTable().getSchema());
        return new SLSDynamicTableSink((Configuration)options, physicalSchema);
    }
}

