/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls;

import com.alibaba.ververica.connectors.common.source.resolver.DefaultSourceCollector;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;

public enum SLSMetadata {
    SOURCE("__source__", DataTypes.STRING(), SLSMetadata.createStringConverter("__source__")),
    TOPIC("__topic__", DataTypes.STRING(), SLSMetadata.createStringConverter("__topic__")),
    TIMESTAMP("__timestamp__", DataTypes.BIGINT(), SLSMetadata.createLongConverter("__timestamp__")),
    TAG("__tag__", DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()), SLSMetadata.createMapConverter("__tag__"));

    private final String key;
    private final DataType dataType;
    private final DefaultSourceCollector.MetadataConverter converter;

    private SLSMetadata(String key, DataType dataType, DefaultSourceCollector.MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DefaultSourceCollector.MetadataConverter getConverter() {
        return this.converter;
    }

    private static DefaultSourceCollector.MetadataConverter createLongConverter(String key) {
        return m3 -> m3.getProperties().get(key) == null ? -1L : Long.parseLong(m3.getProperties().get(key).toString());
    }

    private static DefaultSourceCollector.MetadataConverter createStringConverter(String key) {
        return m3 -> m3.getProperties().get(key) == null ? null : StringData.fromString((String)m3.getProperties().get(key).toString());
    }

    private static DefaultSourceCollector.MetadataConverter createMapConverter(String key) {
        return m3 -> {
            if (m3.getProperties().get(key) == null) {
                return null;
            }
            HashMap<StringData, StringData> map = new HashMap<StringData, StringData>();
            for (Map.Entry entry : ((Map)m3.getProperties().get(key)).entrySet()) {
                map.put(StringData.fromBytes((byte[])((byte[])entry.getKey())), StringData.fromBytes((byte[])((byte[])entry.getValue())));
            }
            return new GenericMapData(map);
        };
    }

    private static DefaultSourceCollector.MetadataConverter createIntConverter(String key) {
        return m3 -> m3.getProperties().get(key) == null ? -1 : Integer.parseInt(m3.getProperties().get(key).toString());
    }
}

