/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls;

import com.alibaba.ververica.connectors.common.util.DateUtil;
import com.alibaba.ververica.connectors.sls.SLSAccessInfo;
import com.alibaba.ververica.connectors.sls.SLSOptions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SLSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SLSUtils.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private SLSUtils() {
    }

    public static SLSAccessInfo parseConsumerConfig(Configuration props) {
        SLSAccessInfo accessInfo = new SLSAccessInfo();
        SLSUtils.parseCommonInfo(accessInfo, props);
        accessInfo.setConsumerGroup(props.getString(SLSOptions.CONSUMER_GROUP));
        accessInfo.setBatchGetSize(props.getInteger(SLSOptions.OPTIONAL_BATCH_GET_SIZE));
        return accessInfo;
    }

    private static void parseCommonInfo(SLSAccessInfo accessInfo, Configuration props) {
        accessInfo.setEndpoint(props.getString(SLSOptions.ENDPOINT));
        accessInfo.setAccessId(props.getString(SLSOptions.ACCESS_ID));
        accessInfo.setAccessKey(props.getString(SLSOptions.ACCESS_KEY));
        accessInfo.setProjectName(props.getString(SLSOptions.PROJECT));
        accessInfo.setLogstore(props.getString(SLSOptions.LOGSTORE));
        accessInfo.setDirectModeEnabled(props.getBoolean(SLSOptions.OPTIONAL_DIRECT_MODE));
        accessInfo.setMaxRetries(props.getInteger(SLSOptions.MAX_RETRIES));
    }

    public static SLSAccessInfo parseProducerConfig(Configuration props) {
        SLSAccessInfo accessInfo = new SLSAccessInfo();
        SLSUtils.parseCommonInfo(accessInfo, props);
        return accessInfo;
    }

    public static int getStartTimeInSecs(String startTime, String timeZone) {
        int startInSec = -1;
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        if (StringUtils.isBlank(startTime)) {
            startTime = formatter.format(new Date());
        }
        try {
            startInSec = (int)(DateUtil.parseDateString(DATE_FORMAT, startTime, timeZone) / 1000L);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Incorrect datetime format: %s, pls use ISO-8601 complete date plus hours, minutes and seconds format:%s", startTime, DATE_FORMAT), e);
        }
        return startInSec;
    }

    public static int getStopTimeInSecs(String stopTime, String timeZone) {
        int stopInSec = -1;
        if (!StringUtils.isBlank(stopTime)) {
            try {
                stopInSec = (int)(DateUtil.parseDateString(DATE_FORMAT, stopTime, timeZone) / 1000L);
            }
            catch (ParseException e) {
                throw new RuntimeException(String.format("Incorrect datetime format: %s, pls use ISO-8601 complete date plus hours, minutes and seconds format:%s", stopTime, DATE_FORMAT), e);
            }
        }
        return stopInSec;
    }

    public static void backoff(long backoffMs) {
        try {
            Thread.sleep(backoffMs);
        }
        catch (InterruptedException ex) {
            LOG.warn("Sleep interrupted");
        }
    }
}

