/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.sink;

import com.alibaba.ververica.connectors.sls.sink.SLSOutputFormat;
import com.alibaba.ververica.connectors.sls.sink.SLSOutputFormatAdapter;
import com.alibaba.ververica.connectors.sls.sink.SLSRecordConverterRowData;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.OutputFormatProvider;
import org.apache.flink.types.RowKind;

public class SLSDynamicTableSink
implements DynamicTableSink {
    private Configuration configuration;
    private TableSchema tableSchema;

    public SLSDynamicTableSink(Configuration configuration, TableSchema tableSchema) {
        this.configuration = configuration;
        this.tableSchema = tableSchema;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        return OutputFormatProvider.of((OutputFormat)new SLSOutputFormatAdapter(this.createSLSOutputFormat(), this.createSLSRecordConverter()));
    }

    public DynamicTableSink copy() {
        return new SLSDynamicTableSink(this.configuration, this.tableSchema);
    }

    public String asSummaryString() {
        return "sls";
    }

    private SLSOutputFormat createSLSOutputFormat() {
        return new SLSOutputFormat(this.configuration);
    }

    private SLSRecordConverterRowData createSLSRecordConverter() {
        return new SLSRecordConverterRowData(this.tableSchema, this.configuration);
    }
}

