/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.sink;

import com.alibaba.ververica.connectors.common.sts.AbstractClientProvider;
import com.alibaba.ververica.connectors.sls.SLSAccessInfo;
import com.alibaba.ververica.connectors.sls.SLSOptions;
import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLSLogProducerProvider
extends AbstractClientProvider<LogProducer> {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractClientProvider.class);
    private SLSAccessInfo accessInfo;
    private Configuration properties;

    public SLSLogProducerProvider(SLSAccessInfo accessInfo, Configuration properties) {
        super(accessInfo.getAccessId(), accessInfo.getAccessKey(), properties);
        this.accessInfo = accessInfo;
        this.properties = properties;
    }

    @Override
    protected void closeClient() {
        if (this.client != null) {
            while (true) {
                try {
                    ((LogProducer)this.client).close();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (ProducerException e) {
                    LOGGER.warn("Exception caught when closing client", e);
                }
                break;
            }
            this.client = null;
        }
    }

    @Override
    protected LogProducer produceNormalClient(String accessId, String accessKey) {
        ProjectConfig projectConfig = new ProjectConfig(this.accessInfo.getProjectName(), this.accessInfo.getEndpoint(), accessId, accessKey);
        return this.createLogProducerInternal(projectConfig, this.properties);
    }

    @Override
    protected LogProducer produceStsClient(String accessId, String accessKey, String securityToken) {
        ProjectConfig projectConfig = new ProjectConfig(this.accessInfo.getProjectName(), this.accessInfo.getEndpoint(), accessId, accessKey, securityToken);
        return this.createLogProducerInternal(projectConfig, this.properties);
    }

    private LogProducer createLogProducerInternal(ProjectConfig projectConfig, Configuration props) {
        ProducerConfig producerConfig = new ProducerConfig();
        producerConfig.setLingerMs(props.getInteger(SLSOptions.FLUSH_INTERNAL_MS));
        producerConfig.setRetries(props.getInteger(SLSOptions.MAX_RETRIES));
        producerConfig.setBaseRetryBackoffMs(props.getLong(SLSOptions.BASE_RETRY_BACK_OFF_TIME_MS));
        producerConfig.setMaxRetryBackoffMs(props.getLong(SLSOptions.MAX_RETRY_BACK_OFF_TIME_MS));
        producerConfig.setMaxBlockMs(props.getLong(SLSOptions.MAX_BLOCK_TIME_MS));
        producerConfig.setIoThreadCount(props.getInteger(SLSOptions.IO_THREAD_NUM));
        LogProducer producer = new LogProducer(producerConfig);
        producer.putProjectConfig(projectConfig);
        return producer;
    }
}

