/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.sink;

import com.alibaba.ververica.connectors.common.sink.HasRetryTimeout;
import com.alibaba.ververica.connectors.common.sink.Syncable;
import com.alibaba.ververica.connectors.common.sink.converter.RecordConverter;
import com.alibaba.ververica.connectors.sls.sink.SLSOutputFormat;
import com.alibaba.ververica.connectors.sls.sink.SinkRecord;
import java.io.IOException;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;

public class SLSOutputFormatAdapter
extends RichOutputFormat<RowData>
implements Syncable,
HasRetryTimeout {
    private SLSOutputFormat outputFormat;
    private RecordConverter<RowData, SinkRecord> converter;
    private transient Configuration configuration;

    public SLSOutputFormatAdapter(SLSOutputFormat outputFormat, RecordConverter<RowData, SinkRecord> converter) {
        this.outputFormat = outputFormat;
        this.converter = converter;
    }

    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        this.outputFormat.setRuntimeContext(t);
    }

    @Override
    public long getRetryTimeout() {
        return this.outputFormat.getRetryTimeout();
    }

    @Override
    public void sync() throws IOException {
        this.outputFormat.sync();
    }

    public void configure(Configuration configuration) {
        this.outputFormat.configure(configuration);
        this.configuration = configuration;
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        this.converter.open(this.getRuntimeContext(), this.configuration);
        this.outputFormat.open(taskNumber, numTasks);
    }

    public void writeRecord(RowData rowData) throws IOException {
        SinkRecord recordEntry;
        if ((rowData.getRowKind() == RowKind.INSERT || rowData.getRowKind() == RowKind.UPDATE_AFTER) && (recordEntry = this.converter.convert(rowData)) != null) {
            this.outputFormat.writeRecord(recordEntry);
        }
    }

    public void close() throws IOException {
        this.converter.close();
        this.outputFormat.close();
    }
}

