/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.sink;

import com.alibaba.ververica.connectors.common.sink.converter.RecordConverter;
import com.alibaba.ververica.connectors.common.util.DateUtil;
import com.alibaba.ververica.connectors.sls.SLSOptions;
import com.alibaba.ververica.connectors.sls.sink.SinkRecord;
import com.aliyun.openservices.log.common.LogItem;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLSRecordConverter
implements RecordConverter<Row, SinkRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(SLSRecordConverter.class);
    private String nullReplaceStr;
    private String timeZone;
    private int timestampColumnIndex = -1;
    private int topicColumnIndex = -1;
    private int sourceColumnIndex = -1;
    private int partitionKeyIndex = -1;
    private String[] fieldNames;
    private int fieldCount;

    public SLSRecordConverter(TableSchema tableSchema, Configuration props) {
        this.nullReplaceStr = props.getString(SLSOptions.NULL_REPLACE_STR);
        this.timeZone = props.getString(SLSOptions.OPTIONAL_TIME_ZONE);
        this.fieldCount = tableSchema.getFieldCount();
        this.fieldNames = tableSchema.getFieldNames();
        String topicField = props.getString(SLSOptions.TOPIC_FIELD);
        String timeField = props.getString(SLSOptions.TIME_FIELD);
        String sourceField = props.getString(SLSOptions.SOURCE_FIELD);
        String partitionField = props.getString(SLSOptions.PARTITION_FIELD);
        for (int i = 0; i < this.fieldCount; ++i) {
            String f = this.fieldNames[i];
            if (f == null) continue;
            if (f.equalsIgnoreCase(timeField)) {
                this.timestampColumnIndex = i;
            }
            if (f.equalsIgnoreCase(topicField)) {
                this.topicColumnIndex = i;
            }
            if (f.equalsIgnoreCase(sourceField)) {
                this.sourceColumnIndex = i;
            }
            if (!f.equalsIgnoreCase(partitionField)) continue;
            this.partitionKeyIndex = i;
        }
    }

    @Override
    public SinkRecord convert(Row row) {
        if (row == null) {
            return null;
        }
        SinkRecord record = new SinkRecord();
        if (this.topicColumnIndex >= 0) {
            record.setTopic(this.getStringValue(row, this.topicColumnIndex));
        }
        if (this.sourceColumnIndex >= 0) {
            record.setSource(this.getStringValue(row, this.sourceColumnIndex));
        }
        if (this.partitionKeyIndex >= 0) {
            record.setPartitionKey(SLSRecordConverter.getMD5(row.getField(this.partitionKeyIndex)));
        }
        LogItem logItem = new LogItem(0);
        if (this.timestampColumnIndex < 0) {
            logItem.SetTime((int)(System.currentTimeMillis() / 1000L));
        } else {
            Preconditions.checkArgument((row.getField(this.timestampColumnIndex) != null ? 1 : 0) != 0, (Object)"timestamp should not be null.");
            logItem.SetTime((Integer)row.getField(this.timestampColumnIndex));
        }
        int fn = row.getArity();
        for (int i = 0; i < fn && i < this.fieldCount; ++i) {
            if (i == this.topicColumnIndex || i == this.sourceColumnIndex || i == this.timestampColumnIndex) continue;
            String key = this.fieldNames[i];
            logItem.PushBack(key, this.getStringValue(row, i));
        }
        record.setContent(logItem);
        return record;
    }

    private String getStringValue(Row row, int index) {
        String value = null == row.getField(index) ? this.nullReplaceStr : (row.getField(index) instanceof Timestamp ? DateUtil.timeStamp2String((Timestamp)row.getField(index), this.timeZone) : (row.getField(index) instanceof Date ? DateUtil.date2String((Date)row.getField(index), this.timeZone) : String.valueOf(row.getField(index))));
        return value;
    }

    private static String getMD5(Object field) {
        if (field == null) {
            return null;
        }
        String str = field.toString();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            LOG.error("md5 encryption error", e);
            return null;
        }
    }
}

