/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.sink;

import com.alibaba.ververica.connectors.common.sink.converter.RecordConverter;
import com.alibaba.ververica.connectors.common.util.DateUtil;
import com.alibaba.ververica.connectors.sls.SLSOptions;
import com.alibaba.ververica.connectors.sls.sink.SinkRecord;
import com.aliyun.openservices.log.common.LogItem;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLSRecordConverterRowData
implements RecordConverter<RowData, SinkRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(SLSRecordConverterRowData.class);
    private static final SimpleDateFormat DATE_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private String nullReplaceStr;
    private String timeZone;
    private int timestampColumnIndex = -1;
    private int topicColumnIndex = -1;
    private int sourceColumnIndex = -1;
    private int partitionKeyIndex = -1;
    private String[] fieldNames;
    private DataType[] fieldsTypes;
    private int fieldCount;

    public SLSRecordConverterRowData(TableSchema tableSchema, Configuration props) {
        this.nullReplaceStr = props.getString(SLSOptions.NULL_REPLACE_STR);
        this.timeZone = props.getString(SLSOptions.OPTIONAL_TIME_ZONE);
        this.fieldCount = tableSchema.getFieldCount();
        this.fieldNames = tableSchema.getFieldNames();
        this.fieldsTypes = tableSchema.getFieldDataTypes();
        String topicField = props.getString(SLSOptions.TOPIC_FIELD);
        String timeField = props.getString(SLSOptions.TIME_FIELD);
        String sourceField = props.getString(SLSOptions.SOURCE_FIELD);
        String partitionField = props.getString(SLSOptions.PARTITION_FIELD);
        for (int i = 0; i < this.fieldCount; ++i) {
            String f = this.fieldNames[i];
            if (f == null) continue;
            if (f.equalsIgnoreCase(timeField)) {
                this.timestampColumnIndex = i;
            }
            if (f.equalsIgnoreCase(topicField)) {
                this.topicColumnIndex = i;
            }
            if (f.equalsIgnoreCase(sourceField)) {
                this.sourceColumnIndex = i;
            }
            if (!f.equalsIgnoreCase(partitionField)) continue;
            this.partitionKeyIndex = i;
        }
    }

    @Override
    public SinkRecord convert(RowData row) {
        if (row == null) {
            return null;
        }
        SinkRecord record = new SinkRecord();
        if (this.topicColumnIndex >= 0) {
            record.setTopic(this.getStringValue(row, this.topicColumnIndex));
        }
        if (this.sourceColumnIndex >= 0) {
            record.setSource(this.getStringValue(row, this.sourceColumnIndex));
        }
        if (this.partitionKeyIndex >= 0) {
            record.setPartitionKey(SLSRecordConverterRowData.getMD5(row, this.partitionKeyIndex));
        }
        LogItem logItem = new LogItem(0);
        if (this.timestampColumnIndex < 0) {
            logItem.SetTime((int)(System.currentTimeMillis() / 1000L));
        } else {
            Preconditions.checkArgument((!row.isNullAt(this.timestampColumnIndex) ? 1 : 0) != 0, (Object)"timestamp should not be null.");
            logItem.SetTime(row.getInt(this.timestampColumnIndex));
        }
        int fn = row.getArity();
        for (int i = 0; i < fn && i < this.fieldCount; ++i) {
            if (i == this.topicColumnIndex || i == this.sourceColumnIndex || i == this.timestampColumnIndex) continue;
            String key = this.fieldNames[i];
            logItem.PushBack(key, this.getStringValue(row, i));
        }
        record.setContent(logItem);
        return record;
    }

    private String getStringValue(RowData row, int index) {
        LogicalType logicType = this.fieldsTypes[index].getLogicalType();
        return this.getString(row, index, logicType);
    }

    private String getString(RowData row, int pos, LogicalType fieldType) {
        if (row.isNullAt(pos)) {
            return this.nullReplaceStr;
        }
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                return row.getBoolean(pos) + "";
            }
            case TINYINT: {
                return row.getByte(pos) + "";
            }
            case SMALLINT: {
                return row.getShort(pos) + "";
            }
            case INTEGER: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return row.getInt(pos) + "";
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return row.getLong(pos) + "";
            }
            case DATE: {
                Date dt = Date.valueOf(LocalDate.ofEpochDay(row.getInt(pos)));
                return DATE_TIME_FORMATTER.format(dt);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)fieldType;
                TimestampData tsData = row.getTimestamp(pos, timestampType.getPrecision());
                return DateUtil.timeStamp2String(tsData.toTimestamp(), this.timeZone);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)fieldType;
                TimestampData tsData = row.getTimestamp(pos, lzTs.getPrecision());
                return DateUtil.timeStamp2String(tsData.toTimestamp(), this.timeZone);
            }
            case FLOAT: {
                return row.getFloat(pos) + "";
            }
            case DOUBLE: {
                return row.getDouble(pos) + "";
            }
            case CHAR: 
            case VARCHAR: {
                return row.getString(pos).toString();
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)fieldType;
                return row.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale()).toString();
            }
            case VARBINARY: {
                return new String(row.getBinary(pos));
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    private static String getMD5(RowData row, int index) {
        if (row.isNullAt(index)) {
            return null;
        }
        String str = row.getString(index).toString();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            LOG.error("md5 encryption error", e);
            return null;
        }
    }
}

