/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.sink;

import com.alibaba.ververica.connectors.common.sink.HasRetryTimeout;
import com.alibaba.ververica.connectors.common.sink.Syncable;
import com.alibaba.ververica.connectors.common.sink.TupleRichOutputFormat;
import com.alibaba.ververica.connectors.common.util.DescriptorPropertiesUtil;
import com.alibaba.ververica.connectors.sls.sink.SLSOutputFormat;
import com.alibaba.ververica.connectors.sls.sink.SLSRecordConverter;
import com.alibaba.ververica.connectors.sls.sink.SinkRecord;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.types.Row;

public class SLSRichOutputFormat
extends TupleRichOutputFormat
implements Syncable,
HasRetryTimeout {
    private SLSRecordConverter recordConverter;
    private SLSOutputFormat writer;
    private Configuration props;

    public SLSRichOutputFormat(TableSchema tableSchema, DescriptorProperties prop) {
        this.props = DescriptorPropertiesUtil.toConfiguration(prop);
        this.writer = new SLSOutputFormat(this.props);
        this.recordConverter = new SLSRecordConverter(tableSchema, this.props);
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.writer.open(taskNumber, numTasks);
        this.recordConverter.open(this.getRuntimeContext(), this.props);
    }

    @Override
    public void writeAddRecord(Row row) throws IOException {
        try {
            SinkRecord record = this.recordConverter.convert(row);
            this.writer.writeRecord(record);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeDeleteRecord(Row row) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void sync() throws IOException {
        this.writer.sync();
    }

    public void close() throws IOException {
        this.writer.close();
        this.recordConverter.close();
    }

    public void configure(Configuration config) {
        this.props.addAll(config);
        this.writer.setRuntimeContext(this.getRuntimeContext());
        this.writer.configure(config);
    }

    @Override
    public long getRetryTimeout() {
        return this.writer.getRetryTimeout();
    }
}

