/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.source;

import com.aliyun.openservices.log.common.FastLogContent;
import com.aliyun.openservices.log.common.FastLogGroup;
import java.lang.reflect.Field;

public class FastLogGetter {
    private final Field fastLogGroupRawBytes;
    private final Field fastLogContentKeyOffset;
    private final Field fastLogContentKeyLength;
    private final Field fastLogContentValueOffset;
    private final Field fastLogContentValueLength;

    public FastLogGetter() {
        try {
            this.fastLogGroupRawBytes = FastLogGroup.class.getDeclaredField("rawBytes");
            this.fastLogGroupRawBytes.setAccessible(true);
            this.fastLogContentKeyOffset = FastLogContent.class.getDeclaredField("keyOffset");
            this.fastLogContentKeyOffset.setAccessible(true);
            this.fastLogContentKeyLength = FastLogContent.class.getDeclaredField("keyLength");
            this.fastLogContentKeyLength.setAccessible(true);
            this.fastLogContentValueOffset = FastLogContent.class.getDeclaredField("valueOffset");
            this.fastLogContentValueOffset.setAccessible(true);
            this.fastLogContentValueLength = FastLogContent.class.getDeclaredField("valueLength");
            this.fastLogContentValueLength.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to get field by reflection. This is unexpected.", e);
        }
    }

    public byte[] getRawBytes(FastLogGroup logGroup) {
        try {
            return (byte[])this.fastLogGroupRawBytes.get(logGroup);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get raw bytes by reflection. This is unexpected.", e);
        }
    }

    public int getKeyOffset(FastLogContent f) {
        try {
            return this.fastLogContentKeyOffset.getInt(f);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get key bytes offset by reflection. This is unexpected.", e);
        }
    }

    public int getKeyLength(FastLogContent f) {
        try {
            return this.fastLogContentKeyLength.getInt(f);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get key bytes length by reflection. This is unexpected.", e);
        }
    }

    public int getValueOffset(FastLogContent f) {
        try {
            return this.fastLogContentValueOffset.getInt(f);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get value bytes offset by reflection. This is unexpected.", e);
        }
    }

    public int getValueLength(FastLogContent f) {
        try {
            return this.fastLogContentValueLength.getInt(f);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get value bytes length by reflection. This is unexpected.", e);
        }
    }
}

