/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.source;

import com.alibaba.ververica.connectors.common.sts.AbstractClientProvider;
import com.alibaba.ververica.connectors.sls.SLSAccessInfo;
import com.aliyun.openservices.log.Client;
import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLSClientProvider
extends AbstractClientProvider<Client> {
    private static Logger LOGGER = LoggerFactory.getLogger(SLSClientProvider.class);
    private SLSAccessInfo accessInfo;

    public SLSClientProvider(SLSAccessInfo accessInfo, Configuration properties) {
        super(accessInfo.getAccessId(), accessInfo.getAccessKey(), properties);
        this.accessInfo = accessInfo;
    }

    @Override
    protected Client produceNormalClient(String accessId, String accessKey) {
        Client client = new Client(this.accessInfo.getEndpoint(), accessId, accessKey);
        client.setUserAgent("Flink-ak-" + this.accessInfo.getConsumerGroup() + "-" + this.getHostName());
        if (this.accessInfo.isDirectModeEnabled()) {
            client.EnableDirectMode();
        }
        return client;
    }

    @Override
    protected Client produceStsClient(String accessId, String accessKey, String securityToken) {
        Client client = new Client(this.accessInfo.getEndpoint(), accessId, accessKey);
        client.setUserAgent("Flink-sts-" + this.accessInfo.getConsumerGroup() + "-" + this.getHostName());
        client.setSecurityToken(securityToken);
        if (this.accessInfo.isDirectModeEnabled()) {
            client.EnableDirectMode();
        }
        return client;
    }

    @Override
    protected void closeClient() {
    }

    private String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

