/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.source;

import com.alibaba.ververica.connectors.common.source.resolver.RecordResolver;
import com.alibaba.ververica.connectors.sls.SLSAccessInfo;
import com.alibaba.ververica.connectors.sls.SLSMetadata;
import com.alibaba.ververica.connectors.sls.source.SLSRecordParserFactory;
import com.alibaba.ververica.connectors.sls.source.SLSSourceFunctionAdapter;
import com.alibaba.ververica.connectors.sls.source.SlsSourceFunction;
import com.alibaba.ververica.connectors.sls.source.SourceRecord;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.types.DataType;

public class SLSDynamicTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private String tableName;
    private int startInSec;
    private int stopInSec;
    private SLSAccessInfo accessInfo;
    private TableSchema tableSchema;
    private DescriptorProperties descriptorProperties;
    private final boolean exitAfterReadFinish;
    private List<String> metadataKeys;

    public SLSDynamicTableSource(String tableName, int startInSec, int stopInSec, SLSAccessInfo accessInfo, TableSchema tableSchema, DescriptorProperties descriptorProperties, boolean exitAfterReadFinish) {
        this.tableName = tableName;
        this.startInSec = startInSec;
        this.stopInSec = stopInSec;
        this.accessInfo = accessInfo;
        this.tableSchema = tableSchema;
        this.descriptorProperties = descriptorProperties;
        this.exitAfterReadFinish = exitAfterReadFinish;
        this.metadataKeys = new ArrayList<String>();
    }

    public DynamicTableSource copy() {
        return new SLSDynamicTableSource(this.tableName, this.startInSec, this.stopInSec, this.accessInfo, this.tableSchema, this.descriptorProperties, this.exitAfterReadFinish);
    }

    public String asSummaryString() {
        return "sls";
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        return SourceFunctionProvider.of((SourceFunction)new SLSSourceFunctionAdapter(this.createSLSSourceFunction(), this.createSLSRecordParser()), (boolean)true);
    }

    private SlsSourceFunction createSLSSourceFunction() {
        SlsSourceFunction source = new SlsSourceFunction(this.accessInfo, this.startInSec, this.stopInSec);
        if (this.exitAfterReadFinish) {
            source.enableExitAfterReadFinished();
        }
        return source;
    }

    private RecordResolver<SourceRecord, RowData> createSLSRecordParser() {
        return SLSRecordParserFactory.createParser(this.tableSchema, this.descriptorProperties.asMap(), this.metadataKeys);
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(SLSMetadata.values()).forEachOrdered(m3 -> metadataMap.putIfAbsent(m3.getKey(), m3.getDataType()));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> list, DataType dataType) {
        this.metadataKeys.clear();
        this.metadataKeys.addAll(list);
    }
}

