/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.source;

import com.alibaba.ververica.connectors.common.MetricUtils;
import com.alibaba.ververica.connectors.common.source.resolver.RecordResolver;
import com.alibaba.ververica.connectors.common.source.resolver.parse.BufferedTextRowData;
import com.alibaba.ververica.connectors.common.util.ByteArray;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import com.alibaba.ververica.connectors.common.util.StringSerializer;
import com.alibaba.ververica.connectors.sls.source.FastLogGetter;
import com.alibaba.ververica.connectors.sls.source.SourceRecord;
import com.aliyun.openservices.log.common.FastLog;
import com.aliyun.openservices.log.common.FastLogContent;
import com.aliyun.openservices.log.common.FastLogGroup;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLSFastRecordParser
implements RecordResolver<SourceRecord, RowData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SLSFastRecordParser.class);
    private static final int DEFAULT_LOG_INTERVAL_MS = 60000;
    private final ByteSerializer.ValueType[] fieldTypes;
    private final DataType[] fieldDataTypes;
    private final String[] fieldNames;
    private final Set<String> nullValues;
    private final byte[][] bytesNullValues;
    private final boolean columnErrorDebug;
    private transient HashMap<ByteArray, Integer> fieldName2Index;
    private transient boolean[] shouldEarlyParse;
    private transient BufferedTextRowData reuseRow;
    private transient FastLogGetter fastLogGetter;
    private transient long lastLogExceptionTime;
    private transient Counter parserSkipMetrics;
    private transient Meter parserTpsMetrics;

    public SLSFastRecordParser(ByteSerializer.ValueType[] fieldTypes, DataType[] fieldDataTypes, String[] fieldNames, Set<String> nullValues, boolean columnErrorDebug) {
        this.fieldTypes = fieldTypes;
        this.fieldDataTypes = fieldDataTypes;
        this.fieldNames = fieldNames;
        this.nullValues = nullValues;
        this.bytesNullValues = (byte[][])nullValues.stream().map(s2 -> s2.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
        this.columnErrorDebug = columnErrorDebug;
    }

    @Override
    public void open(FunctionContext context) {
        this.parserSkipMetrics = MetricUtils.registerNumRecordsInErrors(context);
        this.parserTpsMetrics = MetricUtils.registerNumRecordsInRate(context);
        this.openInternal();
    }

    @VisibleForTesting
    void openInternal() {
        int i;
        this.fieldName2Index = new HashMap();
        for (i = 0; i < this.fieldNames.length; ++i) {
            this.fieldName2Index.put(new ByteArray(this.fieldNames[i].getBytes(StandardCharsets.UTF_8)), i);
        }
        this.shouldEarlyParse = new boolean[this.fieldTypes.length];
        for (i = 0; i < this.fieldTypes.length; ++i) {
            this.shouldEarlyParse[i] = this.fieldTypes[i] != ByteSerializer.ValueType.V_ByteArray && this.fieldTypes[i] != ByteSerializer.ValueType.V_String;
        }
        this.reuseRow = new BufferedTextRowData(this.fieldTypes);
        this.fastLogGetter = new FastLogGetter();
    }

    @Override
    public void parse(SourceRecord input, Collector<RowData> collector) {
        for (FastLogGroup logGroup : input.getLogGroups()) {
            byte[] rawBytes = this.fastLogGetter.getRawBytes(logGroup);
            this.reuseRow.replaceBuffer(rawBytes);
            int logsCount = logGroup.getLogsCount();
            for (int i = 0; i < logsCount; ++i) {
                FastLog log = logGroup.getLogs(i);
                RowData row = this.getRecord(log, rawBytes);
                if (row == null) continue;
                collector.collect((Object)row);
            }
        }
    }

    public TypeInformation<RowData> getProducedType() {
        DataTypes.Field[] fields = new DataTypes.Field[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            fields[i] = DataTypes.FIELD((String)this.fieldNames[i], (DataType)this.fieldDataTypes[i]);
        }
        return InternalTypeInfo.of((LogicalType)DataTypes.ROW((DataTypes.Field[])fields).getLogicalType());
    }

    private RowData getRecord(FastLog log, byte[] rawBytes) {
        if (log == null) {
            return null;
        }
        this.reuseRow.setAllFieldsToNull();
        int fieldCount = log.getContentsCount();
        for (int i = 0; i < fieldCount; ++i) {
            FastLogContent f = log.getContents(i);
            int keyOffset = this.fastLogGetter.getKeyOffset(f);
            if (keyOffset < 0) {
                return null;
            }
            int keyLength = this.fastLogGetter.getKeyLength(f);
            ByteArray key = new ByteArray(rawBytes, keyOffset, keyLength);
            Integer index = this.fieldName2Index.get(key);
            if (index == null) continue;
            if (this.shouldEarlyParse[index]) {
                String value = f.getValue();
                if (value == null || this.nullValues.contains(value)) continue;
                try {
                    this.reuseRow.setField(index, StringSerializer.deserialize(value, this.fieldTypes[index], this.fieldDataTypes[index], false));
                    continue;
                }
                catch (Exception e) {
                    this.logParseException(value, index, e);
                    if (this.parserSkipMetrics != null) {
                        this.parserSkipMetrics.inc();
                    }
                    return null;
                }
            }
            int valueOffset = this.fastLogGetter.getValueOffset(f);
            int valueLength = this.fastLogGetter.getValueLength(f);
            if (valueOffset < 0 || this.isNullField(rawBytes, valueOffset, valueLength)) continue;
            this.reuseRow.setNotNullAt(index);
            this.reuseRow.setPointersAt(index, valueOffset, valueLength);
        }
        if (this.parserTpsMetrics != null) {
            this.parserTpsMetrics.markEvent();
        }
        return this.reuseRow;
    }

    private boolean isNullField(byte[] rawBytes, int offset, int length) {
        block0: for (byte[] nullBytes : this.bytesNullValues) {
            if (nullBytes.length != length) continue;
            for (int i = 0; i < length; ++i) {
                if (rawBytes[offset + i] != nullBytes[i]) continue block0;
            }
            return true;
        }
        return false;
    }

    private void logParseException(String value, int idx, Exception cause) {
        long now = System.currentTimeMillis();
        if (this.columnErrorDebug || now - this.lastLogExceptionTime > 60000L) {
            LOGGER.warn("Data format error, field type: " + (Object)((Object)this.fieldTypes[idx]) + "field data: " + value + ", index: " + idx, cause);
            this.lastLogExceptionTime = now;
        }
    }
}

