/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.source;

import com.alibaba.ververica.connectors.common.source.message.ListStringMessage;
import com.alibaba.ververica.connectors.common.source.message.RawMessage;
import com.alibaba.ververica.connectors.common.source.resolver.DefaultSourceCollector;
import com.alibaba.ververica.connectors.common.source.resolver.RecordResolver;
import com.alibaba.ververica.connectors.sls.source.SourceRecord;
import com.aliyun.openservices.log.common.FastLog;
import com.aliyun.openservices.log.common.FastLogContent;
import com.aliyun.openservices.log.common.FastLogGroup;
import com.aliyun.openservices.log.common.FastLogTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.util.Collector;

public class SLSRecordParser
implements RecordResolver<SourceRecord, RowData> {
    public static final String SOURCE = "__source__";
    public static final String TOPIC = "__topic__";
    public static final String TIMESTAMP = "__timestamp__";
    public static final String TAG = "__tag__";
    private final DefaultSourceCollector sourceCollector;
    private final String[] fieldNames;
    private transient HashMap<String, Integer> fieldName2Index;

    public SLSRecordParser(DefaultSourceCollector sourceCollector, String[] fieldNames) {
        this.sourceCollector = sourceCollector;
        this.fieldNames = fieldNames;
    }

    @Override
    public void open(FunctionContext context) {
        this.sourceCollector.open(context);
        this.openInternal();
    }

    @Override
    public void parse(SourceRecord input, Collector<RowData> collector) {
        List<RawMessage> rawMessages = this.parse(input);
        this.sourceCollector.parse(rawMessages, collector);
    }

    @VisibleForTesting
    void openInternal() {
        this.fieldName2Index = new HashMap();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            this.fieldName2Index.put(this.fieldNames[i], i);
        }
    }

    @VisibleForTesting
    List<RawMessage> parse(SourceRecord record) {
        ArrayList<RawMessage> rawInput = new ArrayList<RawMessage>();
        for (FastLogGroup logGroup : record.getLogGroups()) {
            try {
                int i;
                int logsCount = logGroup.getLogsCount();
                ArrayList<T[]> rawRecords = new ArrayList<T[]>(logsCount);
                ListStringMessage message = new ListStringMessage();
                int tagsNum = logGroup.getLogTagsCount();
                for (i = 0; i < tagsNum; ++i) {
                    FastLogTag tag = logGroup.getLogTags(i);
                    message.setProperty(tag.getKey(), tag.getValue());
                }
                message.setProperty(SOURCE, logGroup.getSource());
                message.setProperty(TOPIC, logGroup.getTopic());
                for (i = 0; i < logsCount; ++i) {
                    FastLog log = logGroup.getLogs(i);
                    String timeStr = String.valueOf(log.getTime());
                    message.setProperty(TIMESTAMP, timeStr);
                    String[] rawRecord = this.getRecord(log);
                    if (rawRecord == null) continue;
                    rawRecords.add(rawRecord);
                }
                HashMap<byte[], byte[]> tags = new HashMap<byte[], byte[]>();
                for (FastLogTag tag : logGroup.getTags()) {
                    tags.put(tag.getKeyBytes(), tag.getValueBytes());
                }
                message.setProperty(TAG, tags);
                message.setData(rawRecords);
                rawInput.add(message);
            }
            catch (Exception e) {
                throw new RuntimeException("ERROR in next method :" + e.getMessage(), e);
            }
        }
        return rawInput;
    }

    private String[] getRecord(FastLog log) {
        if (log == null) {
            return null;
        }
        String[] fieldValues = new String[this.fieldNames.length];
        int fieldCount = log.getContentsCount();
        for (int i = 0; i < fieldCount; ++i) {
            FastLogContent f = log.getContents(i);
            String key = f.getKey();
            Integer index = this.fieldName2Index.get(key);
            if (index == null) continue;
            fieldValues[index.intValue()] = f.getValue();
        }
        return fieldValues;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.sourceCollector.getProducedType();
    }
}

