/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.sls.source;

import com.alibaba.ververica.connectors.common.source.resolver.DefaultSourceCollector;
import com.alibaba.ververica.connectors.common.source.resolver.DirtyDataStrategy;
import com.alibaba.ververica.connectors.common.source.resolver.RecordResolver;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import com.alibaba.ververica.connectors.sls.SLSMetadata;
import com.alibaba.ververica.connectors.sls.source.SLSFastRecordParser;
import com.alibaba.ververica.connectors.sls.source.SLSRecordParser;
import com.alibaba.ververica.connectors.sls.source.SourceRecord;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;

public class SLSRecordParserFactory {
    public static RecordResolver<SourceRecord, RowData> createParser(TableSchema tableSchema, Map<String, String> params, List<String> metadataKeys) {
        DefaultSourceCollector.MetadataConverter[] metadataConverters = (DefaultSourceCollector.MetadataConverter[])metadataKeys.stream().map(k -> Stream.of(SLSMetadata.values()).filter(rm -> rm.getKey().equals(k)).findFirst().orElseThrow(IllegalStateException::new)).map(SLSMetadata::getConverter).toArray(DefaultSourceCollector.MetadataConverter[]::new);
        DefaultSourceCollector collector = new DefaultSourceCollector.Builder().setProperties(params).setTableSchema(tableSchema).setHasMetadata(metadataConverters.length > 0).setMetadataConverters(metadataConverters).build();
        Set<String> nullValues = collector.getNullValues();
        if (collector.getFormatErrorStrategy() == DirtyDataStrategy.SKIP && metadataConverters.length == 0) {
            return new SLSFastRecordParser(SLSRecordParserFactory.getFieldTypes(tableSchema), tableSchema.getFieldDataTypes(), tableSchema.getFieldNames(), nullValues == null ? Collections.emptySet() : nullValues, collector.getColumnErrorDebug());
        }
        return new SLSRecordParser(collector, tableSchema.getFieldNames());
    }

    private static ByteSerializer.ValueType[] getFieldTypes(TableSchema schema) {
        int fieldCount = schema.getFieldCount();
        ByteSerializer.ValueType[] types = new ByteSerializer.ValueType[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            ByteSerializer.ValueType type;
            types[i] = type = ByteSerializer.getTypeIndex(schema.getFieldTypes()[i].getTypeClass());
        }
        return types;
    }
}

