/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.sts.fetcher.retriever;

import com.alibaba.ververica.sts.fetcher.config.StsFetcherConfigOptions;
import com.alibaba.ververica.sts.fetcher.entity.StsCredential;
import com.alibaba.ververica.sts.fetcher.retriever.StsCredentialRetriever;
import com.alibaba.ververica.sts.fetcher.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsCredentialFileRetriever
implements StsCredentialRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(StsCredentialFileRetriever.class);
    private String fileRootPath = null;
    private String akIdFileName = null;
    private String akSecretFilename = null;
    private String akTokenFilename = null;
    private Long expireSeconds = null;

    @Override
    public void initialize(Map<String, String> config) {
        String fileRootPath = StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_CREDENTIAL_ROOT_PATH).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.file.credential.root.path]."));
        String akIdFileName = StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_FILE_CREDENTIAL_ACCESS_KEY_ID_FILENAME).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.file.credential.ak.id.filename]."));
        String akSecretFilename = StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_FILE_CREDENTIAL_ACCESS_KEY_SECRET_FILENAME).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.file.credential.ak.secret.filename]."));
        String akTokenFilename = StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_FILE_CREDENTIAL_ACCESS_KEY_TOKEN_FILENAME).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.file.credential.ak.token.filename]."));
        Long expireSeconds = Long.valueOf(StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_CREDENTIAL_EXPIRE_SECONDS).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.credential.expire.seconds].")));
        this.fileRootPath = fileRootPath;
        this.akIdFileName = akIdFileName;
        this.akSecretFilename = akSecretFilename;
        this.akTokenFilename = akTokenFilename;
        this.expireSeconds = expireSeconds;
    }

    @Override
    public StsCredential getStsCredential() {
        try {
            return StsCredential.builder().accessKeyId(this.readContent(Paths.get(this.fileRootPath, this.akIdFileName))).accessKeySecret(this.readContent(Paths.get(this.fileRootPath, this.akSecretFilename))).stsToken(this.readContent(Paths.get(this.fileRootPath, this.akTokenFilename))).expireSeconds(this.expireSeconds).build();
        }
        catch (Throwable t) {
            LOG.error("Failed to read content from file.", t);
            return null;
        }
    }

    private String readContent(Path filePath) {
        try {
            return FileUtils.readContentInFile(filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to read content from file, path: [%s], ", filePath.toAbsolutePath().toString()));
        }
    }
}

