/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.sts.fetcher.retriever;

import com.alibaba.ververica.sts.fetcher.config.StsFetcherConfigOptions;
import com.alibaba.ververica.sts.fetcher.entity.StsCredential;
import com.alibaba.ververica.sts.fetcher.retriever.StsCredentialRetriever;
import com.alibaba.ververica.sts.fetcher.utils.HttpUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsCredentialHttpRetriever
implements StsCredentialRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(StsCredentialHttpRetriever.class);
    private String akIdHttpAddress = null;
    private String akSecretHttpAddress = null;
    private String akTokenHttpAddress = null;
    private Long expireSeconds = null;

    @Override
    public void initialize(Map<String, String> config) {
        String akIdHttpAddress = StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_HTTP_CREDENTIAL_ACCESS_KEY_ID_ADDRESS).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.http.credential.ak.id.address]."));
        String akSecretHttpAddress = StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_HTTP_CREDENTIAL_ACCESS_KEY_SECRET_ADDRESS).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.http.credential.ak.secret.address]."));
        String akTokenHttpAddress = StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_HTTP_CREDENTIAL_ACCESS_KEY_TOKEN_ADDRESS).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.http.credential.ak.token.address]."));
        Long expireSeconds = Long.valueOf(StsFetcherConfigOptions.getValue(config, StsFetcherConfigOptions.STS_PROVIDER_CREDENTIAL_EXPIRE_SECONDS).orElseThrow(() -> new IllegalArgumentException("Failed to initialize sts credential file fetcher, can't find value for [sts.provider.credential.expire.seconds].")));
        this.akIdHttpAddress = akIdHttpAddress;
        this.akSecretHttpAddress = akSecretHttpAddress;
        this.akTokenHttpAddress = akTokenHttpAddress;
        this.expireSeconds = expireSeconds;
    }

    @Override
    public StsCredential getStsCredential() {
        try {
            return StsCredential.builder().accessKeyId(HttpUtils.get(URI.create(this.akIdHttpAddress).toURL())).accessKeySecret(HttpUtils.get(URI.create(this.akSecretHttpAddress).toURL())).stsToken(HttpUtils.get(URI.create(this.akTokenHttpAddress).toURL())).expireSeconds(this.expireSeconds).build();
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to fetch sts credential from certain http address caused by invalid http address.", e);
            return null;
        }
        catch (IOException e) {
            LOG.error("Failed to fetch sts credential from certain http address caused by io exception.", e);
            return null;
        }
    }
}

