/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ACLPrivileges
implements Serializable {
    private static final long serialVersionUID = 6030989355388970839L;
    private List<Consts.ACLPrivilege> privileges = new ArrayList<Consts.ACLPrivilege>();

    public ACLPrivileges() {
    }

    public ACLPrivileges(List<Consts.ACLPrivilege> privileges) {
        this.SetPrivileges(privileges);
    }

    public ACLPrivileges(ACLPrivileges other) {
        this.SetPrivileges(other.GetPrivileges());
    }

    public void AddPrivilege(Consts.ACLPrivilege privilege) {
        boolean flag = true;
        for (Consts.ACLPrivilege curPrivilege : this.privileges) {
            if (!curPrivilege.equals((Object)privilege)) continue;
            flag = false;
        }
        if (flag) {
            this.privileges.add(privilege);
        }
    }

    public void AddPrivileges(List<Consts.ACLPrivilege> privileges) {
        for (Consts.ACLPrivilege privilege : privileges) {
            this.AddPrivilege(privilege);
        }
    }

    public void SetPrivileges(List<Consts.ACLPrivilege> privileges) {
        this.privileges = new ArrayList<Consts.ACLPrivilege>();
        this.AddPrivileges(privileges);
    }

    public List<Consts.ACLPrivilege> GetPrivileges() {
        return this.privileges;
    }

    public JSONArray ToJsonArray() {
        JSONArray privilegesArray = new JSONArray();
        for (Consts.ACLPrivilege privilege : this.privileges) {
            privilegesArray.add(privilege.toString());
        }
        return privilegesArray;
    }

    public String ToJsonString() {
        return this.ToJsonArray().toString();
    }

    public void FromJsonArray(JSONArray privilegesArray) throws LogException {
        try {
            this.privileges = new ArrayList<Consts.ACLPrivilege>();
            for (int i = 0; i < privilegesArray.size(); ++i) {
                if (privilegesArray.getString(i).equals("READ")) {
                    this.AddPrivilege(Consts.ACLPrivilege.READ);
                } else if (privilegesArray.getString(i).equals("WRITE")) {
                    this.AddPrivilege(Consts.ACLPrivilege.WRITE);
                }
                if (privilegesArray.getString(i).equals("LIST")) {
                    this.AddPrivilege(Consts.ACLPrivilege.LIST);
                    continue;
                }
                if (!privilegesArray.getString(i).equals("ADMIN")) continue;
                this.AddPrivilege(Consts.ACLPrivilege.ADMIN);
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateACLPrivileges", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String privilegesStr) throws LogException {
        try {
            JSONArray privilegesArray = JSONArray.parseArray(privilegesStr);
            this.FromJsonArray(privilegesArray);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateACLPrivileges", e.getMessage(), e, "");
        }
    }
}

