/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IndexLine {
    private List<String> token = new ArrayList<String>();
    private boolean caseSensitive;
    private boolean chn;
    private List<String> includeKeys = new ArrayList<String>();
    private List<String> excludeKeys = new ArrayList<String>();

    public IndexLine() {
    }

    public IndexLine(List<String> token, boolean caseSensitive) {
        this.SetToken(token);
        this.caseSensitive = caseSensitive;
        this.chn = false;
    }

    public IndexLine(IndexLine other) {
        this.SetToken(other.GetToken());
        this.caseSensitive = other.GetCaseSensitive();
        this.chn = other.GetChn();
        this.SetIncludeKeys(other.GetIncludeKeys());
        this.SetExcludeKeys(other.GetExcludeKeys());
    }

    public List<String> GetToken() {
        return this.token;
    }

    public boolean GetCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean GetChn() {
        return this.chn;
    }

    public void SetToken(List<String> token) {
        this.token = new ArrayList<String>(token);
    }

    public void SetCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void SetChn(boolean chn) {
        this.chn = chn;
    }

    public List<String> GetIncludeKeys() {
        return this.includeKeys;
    }

    public List<String> GetExcludeKeys() {
        return this.excludeKeys;
    }

    public void SetIncludeKeys(List<String> includeKeys) {
        this.includeKeys = new ArrayList<String>(includeKeys);
    }

    public void SetExcludeKeys(List<String> excludeKeys) {
        this.excludeKeys = new ArrayList<String>(excludeKeys);
    }

    public JSONObject ToRequestJson() {
        JSONObject line = new JSONObject();
        JSONArray tokenDict = new JSONArray();
        tokenDict.addAll((Collection<?>)this.token);
        line.put("token", (Object)tokenDict);
        if (this.includeKeys.size() > 0) {
            JSONArray includeKeysDict = new JSONArray();
            includeKeysDict.addAll((Collection<?>)this.includeKeys);
            line.put("include_keys", (Object)includeKeysDict);
        }
        if (this.excludeKeys.size() > 0) {
            JSONArray excludeKeysDict = new JSONArray();
            excludeKeysDict.addAll((Collection<?>)this.excludeKeys);
            line.put("exclude_keys", (Object)excludeKeysDict);
        }
        line.put("caseSensitive", (Object)this.GetCaseSensitive());
        line.put("chn", (Object)this.GetChn());
        return line;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        return this.ToRequestJson();
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            int i;
            if (dict.containsKey("caseSensitive")) {
                this.SetCaseSensitive(dict.getBoolean("caseSensitive"));
            } else {
                this.SetCaseSensitive(false);
            }
            if (dict.containsKey("chn")) {
                this.SetChn(dict.getBooleanValue("chn"));
            } else {
                this.SetChn(false);
            }
            JSONArray tokenDict = dict.getJSONArray("token");
            this.token = new ArrayList<String>();
            for (int i2 = 0; i2 < tokenDict.size(); ++i2) {
                this.token.add(tokenDict.getString(i2));
            }
            if (dict.containsKey("include_keys")) {
                JSONArray includeKeysDict = dict.getJSONArray("include_keys");
                this.includeKeys = new ArrayList<String>();
                for (i = 0; i < includeKeysDict.size(); ++i) {
                    this.includeKeys.add(includeKeysDict.getString(i));
                }
            }
            if (dict.containsKey("exclude_keys")) {
                JSONArray excludeKeysDict = dict.getJSONArray("exclude_keys");
                this.excludeKeys = new ArrayList<String>();
                for (i = 0; i < excludeKeysDict.size(); ++i) {
                    this.excludeKeys.add(excludeKeysDict.getString(i));
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexLine", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexLineString) throws LogException {
        try {
            JSONObject dict = JSONObject.parseObject(indexLineString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexLine", e.getMessage(), e, "");
        }
    }
}

