/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.OssShipperCsvStorageDetail;
import com.aliyun.openservices.log.common.OssShipperJsonStorageDetail;
import com.aliyun.openservices.log.common.OssShipperParquetStorageDetail;
import com.aliyun.openservices.log.common.OssShipperStorageDetail;
import com.aliyun.openservices.log.common.ShipperConfig;
import com.aliyun.openservices.log.exception.LogException;

public class OssShipperConfig
implements ShipperConfig {
    private String ossBucket;
    private String ossPrefix;
    private String roleArn;
    private int bufferInterval;
    private int bufferMB;
    private String compressType;
    private String pathFormat;
    private String timeZone;
    private OssShipperStorageDetail storageDetail;

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInterval, int bufferMB) {
        this(ossBucket, ossPrefix, roleArn, bufferInterval, bufferMB, "snappy");
    }

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInterval, int bufferMB, String compressType) {
        this(ossBucket, ossPrefix, roleArn, bufferInterval, bufferMB, compressType, "%Y/%m/%d/%H/%M", "json", "");
    }

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInterval, int bufferMB, String compressType, String pathFormat) {
        this(ossBucket, ossPrefix, roleArn, bufferInterval, bufferMB, compressType, pathFormat, "json", "");
    }

    public OssShipperConfig(String ossBucket, String ossPrefix, String roleArn, int bufferInterval, int bufferMB, String compressType, String pathFormat, String storageFormat, String timezone) {
        this.ossBucket = ossBucket;
        this.ossPrefix = ossPrefix;
        this.roleArn = roleArn;
        this.bufferInterval = bufferInterval;
        this.bufferMB = bufferMB;
        this.compressType = compressType;
        this.pathFormat = pathFormat;
        this.storageDetail = storageFormat.equals("parquet") ? new OssShipperParquetStorageDetail() : (storageFormat.equals("csv") ? new OssShipperCsvStorageDetail() : new OssShipperJsonStorageDetail());
        this.timeZone = timezone;
    }

    public OssShipperConfig() {
    }

    @Override
    public void FromJsonObj(JSONObject obj) throws LogException {
        try {
            this.ossBucket = obj.getString("ossBucket");
            this.ossPrefix = obj.getString("ossPrefix");
            this.roleArn = obj.getString("roleArn");
            this.bufferInterval = obj.getIntValue("bufferInterval");
            this.bufferMB = obj.getIntValue("bufferSize");
            this.compressType = obj.getString("compressType");
            this.pathFormat = obj.getString("pathFormat");
            this.timeZone = obj.containsKey("timeZone") ? obj.getString("timeZone") : "";
            JSONObject storage = obj.getJSONObject("storage");
            String storageFormat = storage.getString("format");
            this.storageDetail = storageFormat.equals("parquet") ? new OssShipperParquetStorageDetail() : (storageFormat.equals("csv") ? new OssShipperCsvStorageDetail() : new OssShipperJsonStorageDetail());
            this.storageDetail.FromJsonObject(obj);
        }
        catch (JSONException e) {
            throw new LogException("FailToParseOssShipperConfig", e.getMessage(), e, "");
        }
    }

    public OssShipperStorageDetail GetStorageDetail() {
        return this.storageDetail;
    }

    public String GetPathFormat() {
        return this.pathFormat;
    }

    public String GetOssBucket() {
        return this.ossBucket;
    }

    public String GetOssPrefix() {
        return this.ossPrefix;
    }

    public String GetRoleArm() {
        return this.roleArn;
    }

    public int GetBufferInterval() {
        return this.bufferInterval;
    }

    public int GetBufferMB() {
        return this.bufferMB;
    }

    public String GetCompressType() {
        return this.compressType;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setOssBucket(String ossBucket) {
        this.ossBucket = ossBucket;
    }

    public void setOssPrefix(String ossPrefix) {
        this.ossPrefix = ossPrefix;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public void setBufferInterval(int bufferInterval) {
        this.bufferInterval = bufferInterval;
    }

    public void setBufferMB(int bufferMB) {
        this.bufferMB = bufferMB;
    }

    public void setCompressType(String compressType) {
        this.compressType = compressType;
    }

    public void setPathFormat(String pathFormat) {
        this.pathFormat = pathFormat;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setStorageDetail(OssShipperStorageDetail storageDetail) {
        this.storageDetail = storageDetail;
    }

    @Override
    public String GetShipperType() {
        return "oss";
    }

    @Override
    public JSONObject GetJsonObj() {
        JSONObject obj = this.storageDetail.ToJsonObject();
        obj.put("ossBucket", (Object)this.ossBucket);
        obj.put("ossPrefix", (Object)this.ossPrefix);
        obj.put("roleArn", (Object)this.roleArn);
        obj.put("bufferInterval", (Object)this.bufferInterval);
        obj.put("bufferSize", (Object)this.bufferMB);
        obj.put("compressType", (Object)this.compressType);
        obj.put("pathFormat", (Object)this.pathFormat);
        obj.put("timeZone", (Object)this.timeZone);
        return obj;
    }
}

