/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;

public class Project
implements Serializable {
    private static final long serialVersionUID = 3190120783809426119L;
    protected String projectName = "";
    protected String projectStatus = "";
    protected String projectOwner = "";
    protected String projectDesc = "";
    protected String region = "";
    protected String createTime = "";
    protected String lastModifyTime = "";

    public Project() {
    }

    public Project(String projectName, String projectStatus, String projectOwner, String projectDesc, String region, String createTime, String lastModifyTime) {
        this.projectName = projectName;
        this.projectStatus = projectStatus;
        this.projectOwner = projectOwner;
        this.projectDesc = projectDesc;
        this.region = region;
        this.createTime = createTime;
        this.lastModifyTime = lastModifyTime;
    }

    public Project(Project project) {
        this.projectName = project.getProjectName();
        this.projectStatus = project.getProjectStatus();
        this.projectOwner = project.getProjectOwner();
        this.projectDesc = project.getProjectDesc();
        this.region = project.getRegion();
        this.createTime = project.getCreateTime();
        this.lastModifyTime = project.getLastModifyTime();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectStatus() {
        return this.projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public String getProjectOwner() {
        return this.projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public String getProjectDesc() {
        return this.projectDesc;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getLastModifyTime() {
        return this.lastModifyTime;
    }

    public void setLastModifyTime(String lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    private JSONObject ToRequestJson() {
        JSONObject projectDict = new JSONObject();
        projectDict.put("projectName", (Object)this.getProjectName());
        projectDict.put("status", (Object)this.getProjectStatus());
        projectDict.put("owner", (Object)this.getProjectOwner());
        projectDict.put("description", (Object)this.getProjectDesc());
        projectDict.put("region", (Object)this.getRegion());
        return projectDict;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        JSONObject projectDict = this.ToRequestJson();
        projectDict.put("createTime", (Object)this.getCreateTime());
        projectDict.put("lastModifyTime", (Object)this.getLastModifyTime());
        return projectDict;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.setProjectName(dict.getString("projectName"));
            this.setProjectDesc(dict.getString("description"));
            this.setProjectOwner(dict.getString("owner"));
            this.setProjectStatus(dict.getString("status"));
            this.setRegion(dict.getString("region"));
            this.setCreateTime(dict.getString("createTime"));
            this.setLastModifyTime(dict.getString("lastModifyTime"));
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateProject", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String projectString) throws LogException {
        try {
            JSONObject dict = JSONObject.parseObject(projectString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateProject", e.getMessage(), e, "");
        }
    }
}

