/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.Map;

public class TopostoreRelation
implements Serializable {
    private String relationId = "";
    private String relationType = "";
    private String srcNodeId = null;
    private String dstNodeId = null;
    private String property = null;
    private String description = null;
    private String displayName = null;
    private long createTime = 0L;
    private long lastModifyTime = 0L;

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public TopostoreRelation(String relationId, String relationType, String srcNodeId, String dstNodeId) {
        this(relationId, relationType, srcNodeId, dstNodeId, null, null);
    }

    public TopostoreRelation(String relationId, String relationType, String srcNodeId, String dstNodeId, String property) {
        this(relationId, relationType, srcNodeId, dstNodeId, property, null);
    }

    public TopostoreRelation(String relationId, String relationType, String srcNodeId, String dstNodeId, String property, String description) {
        this.relationId = relationId;
        this.relationType = relationType;
        this.srcNodeId = srcNodeId;
        this.dstNodeId = dstNodeId;
        this.property = property;
        this.description = description;
    }

    public TopostoreRelation() {
    }

    public String getRelationId() {
        return this.relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public String getSrcNodeId() {
        return this.srcNodeId;
    }

    public void setSrcNodeId(String srcNodeId) {
        this.srcNodeId = srcNodeId;
    }

    public String getDstNodeId() {
        return this.dstNodeId;
    }

    public void setDstNodeId(String dstNodeId) {
        this.dstNodeId = dstNodeId;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setProperty(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        JSONObject proObj = new JSONObject();
        for (Map.Entry<String, String> kv : properties.entrySet()) {
            proObj.put(kv.getKey(), (Object)kv.getValue());
        }
        this.setProperty(proObj.toJSONString());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject result = new JSONObject();
        result.put("relationId", (Object)this.getRelationId());
        result.put("relationType", (Object)this.getRelationType());
        result.put("srcNodeId", (Object)this.getSrcNodeId());
        result.put("dstNodeId", (Object)this.getDstNodeId());
        if (this.property != null) {
            result.put("property", (Object)this.getProperty());
        }
        if (this.description != null) {
            result.put("description", (Object)this.getDescription());
        }
        if (this.displayName != null) {
            result.put("displayName", (Object)this.getDisplayName());
        }
        return result;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toJSONString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        this.setRelationId(dict.getString("relationId"));
        this.setRelationType(dict.getString("relationType"));
        this.setSrcNodeId(dict.getString("srcNodeId"));
        this.setDstNodeId(dict.getString("dstNodeId"));
        if (dict.containsKey("property")) {
            this.setProperty(dict.getString("property"));
        }
        if (dict.containsKey("displayName")) {
            this.setDisplayName(dict.getString("displayName"));
        }
        if (dict.containsKey("description")) {
            this.setDescription(dict.getString("description"));
        }
        if (dict.containsKey("createTime")) {
            this.createTime = dict.getIntValue("createTime");
        }
        if (dict.containsKey("lastModifyTime")) {
            this.lastModifyTime = dict.getIntValue("lastModifyTime");
        }
    }

    public void FromJsonString(String content) throws LogException {
        JSONObject dict = JSONObject.parseObject(content);
        this.FromJsonObject(dict);
    }

    public void checkForCreate() throws IllegalArgumentException {
        if (this.relationId == null || this.relationId.isEmpty()) {
            throw new IllegalArgumentException("topostore relation id is null/empty");
        }
        if (this.relationType == null || this.relationType.isEmpty()) {
            throw new IllegalArgumentException("topostore relation type is null/empty");
        }
        if (this.property != null && this.property.length() > 0) {
            try {
                JSONObject.parseObject(this.property);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("topostore relation property not valid json");
            }
        }
    }

    public void checkForUpsert() throws IllegalArgumentException {
        this.checkForCreate();
    }

    public void checkForUpdate() throws IllegalArgumentException {
        this.checkForCreate();
    }
}

