/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.sample;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Shard;
import com.aliyun.openservices.log.exception.LogException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;

public class ShardBalanceTool {
    static String endpoint = "";
    static String project = "";
    static String logstore = "";
    static String accesskeyId = "";
    static String accesskey = "";

    static ArrayList<String> Split(int count) {
        if (count <= 1) {
            throw new IllegalArgumentException("count > 1");
        }
        ArrayList<String> sps = new ArrayList<String>();
        BigInteger max = new BigInteger("ffffffffffffffffffffffffffffffff", 16);
        max.add(new BigInteger("1", 10));
        BigInteger step = max.divide(new BigInteger(count + "", 10));
        BigInteger res = new BigInteger("0", 10);
        for (int i = 0; i < count - 1; ++i) {
            res = res.add(step);
            String hash = res.toString(16);
            while (hash.length() < 32) {
                hash = "0" + hash;
            }
            sps.add(hash);
        }
        return sps;
    }

    static ArrayList<String> SplitWithBound(int count) {
        ArrayList<String> sps = ShardBalanceTool.Split(count);
        sps.add(0, "00000000000000000000000000000000");
        sps.add(sps.size(), "ffffffffffffffffffffffffffffffff");
        return sps;
    }

    static boolean Contain(String bhash, String ehash, String sp) {
        return bhash.compareToIgnoreCase(sp) <= 0 && ehash.compareToIgnoreCase(sp) > 0;
    }

    public static void main(String[] args) throws LogException, InterruptedException {
        int count = 24;
        ArrayList<String> res = ShardBalanceTool.Split(count);
        System.out.println(res);
        Client client = new Client(endpoint, accesskeyId, accesskey);
        while (res.size() > 0) {
            ArrayList<Shard> shards = client.ListShard(project, logstore).GetShards();
            System.out.println("list shards: " + shards);
            HashSet<String> eraseHash = new HashSet<String>();
            block1: for (Shard shard : shards) {
                if (shard.getStatus().compareToIgnoreCase("readwrite") != 0) continue;
                for (String hash : res) {
                    if (shard.getInclusiveBeginKey().compareToIgnoreCase(hash) != 0 && ShardBalanceTool.Contain(shard.getInclusiveBeginKey(), shard.getExclusiveEndKey(), hash)) {
                        System.out.println("split shard: " + shard.toString());
                        client.SplitShard(project, logstore, shard.GetShardId(), hash);
                        eraseHash.add(hash);
                        continue block1;
                    }
                    if (shard.getInclusiveBeginKey().compareToIgnoreCase(hash) != 0) continue;
                    eraseHash.add(hash);
                    continue block1;
                }
            }
            ArrayList<String> newRes = new ArrayList<String>();
            for (String hash : res) {
                if (eraseHash.contains(hash)) continue;
                newRes.add(hash);
            }
            res = newRes;
            if (res.size() <= 0) continue;
            Thread.sleep(60000L);
        }
        Thread.sleep(60000L);
        res = ShardBalanceTool.SplitWithBound(count);
        boolean mloop = true;
        while (mloop) {
            mloop = false;
            ArrayList<Shard> shards = client.ListShard(project, logstore).GetShards();
            for (int i = 1; i < res.size(); ++i) {
                String string = res.get(i - 1);
                String eh = res.get(i);
                ArrayList<Shard> rangeShards = new ArrayList<Shard>();
                for (Shard s2 : shards) {
                    if (s2.getStatus().compareToIgnoreCase("readwrite") != 0 || !ShardBalanceTool.Contain(string, eh, s2.getInclusiveBeginKey())) continue;
                    rangeShards.add(s2);
                }
                if (rangeShards.size() <= 1) continue;
                System.out.println("merge shard: " + ((Shard)rangeShards.get(0)).toString());
                client.MergeShards(project, logstore, ((Shard)rangeShards.get(0)).GetShardId());
                mloop = true;
            }
            Thread.sleep(60000L);
        }
    }
}

