/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.anno.support.AbstractLifecycle;
import com.alicp.jetcache.anno.support.CacheMonitorManager;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.external.ExternalCacheConfig;
import com.alicp.jetcache.support.CacheNotifyMonitor;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.DefaultMetricsManager;
import com.alicp.jetcache.support.StatInfo;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultCacheMonitorManager
extends AbstractLifecycle
implements CacheMonitorManager {
    private DefaultMetricsManager defaultMetricsManager;
    @Resource
    private GlobalCacheConfig globalCacheConfig;
    @Autowired(required=false)
    private Consumer<StatInfo> metricsCallback;
    @Resource
    private ConfigProvider configProvider;

    @Override
    public void addMonitors(String area, String cacheName, Cache cache, boolean syncLocal) {
        this.addMetricsMonitor(area, cacheName, cache);
        this.addNotifyMonitor(area, cacheName, cache, syncLocal);
    }

    protected void addNotifyMonitor(String area, String cacheName, Cache cache, boolean syncLocal) {
        if (!syncLocal) {
            return;
        }
        if (!(CacheUtil.getAbstractCache((Cache)cache) instanceof MultiLevelCache)) {
            return;
        }
        ExternalCacheBuilder cacheBuilder = (ExternalCacheBuilder)this.globalCacheConfig.getRemoteCacheBuilders().get(area);
        if (cacheBuilder == null || !cacheBuilder.supportBroadcast() || cacheBuilder.getConfig().getBroadcastChannel() == null) {
            return;
        }
        CacheManager cacheManager = this.configProvider.getCacheManager();
        if (cacheManager.getBroadcastManager(area) == null) {
            ExternalCacheBuilder builderCopy = (ExternalCacheBuilder)cacheBuilder.clone();
            MultiLevelCache mc = (MultiLevelCache)CacheUtil.getAbstractCache((Cache)cache);
            ExternalCacheConfig cacheConfig = (ExternalCacheConfig)mc.caches()[mc.caches().length - 1].config();
            builderCopy.setValueEncoder(cacheConfig.getValueEncoder());
            builderCopy.setValueDecoder(cacheConfig.getValueDecoder());
            cacheManager.putBroadcastManager(area, builderCopy.createBroadcastManager(cacheManager));
        }
        CacheNotifyMonitor monitor = new CacheNotifyMonitor(cacheManager, area, cacheName);
        cache.config().getMonitors().add(monitor);
    }

    protected void addMetricsMonitor(String area, String cacheName, Cache cache) {
        if (this.defaultMetricsManager != null) {
            MultiLevelCache mc;
            if ((cache = CacheUtil.getAbstractCache((Cache)cache)) instanceof MultiLevelCache && (mc = (MultiLevelCache)cache).caches().length == 2) {
                Cache local = mc.caches()[0];
                Cache remote = mc.caches()[1];
                DefaultCacheMonitor localMonitor = new DefaultCacheMonitor(cacheName + "_local");
                local.config().getMonitors().add(localMonitor);
                DefaultCacheMonitor remoteMonitor = new DefaultCacheMonitor(cacheName + "_remote");
                remote.config().getMonitors().add(remoteMonitor);
                this.defaultMetricsManager.add(new DefaultCacheMonitor[]{localMonitor, remoteMonitor});
            }
            DefaultCacheMonitor monitor = new DefaultCacheMonitor(cacheName);
            cache.config().getMonitors().add(monitor);
            this.defaultMetricsManager.add(new DefaultCacheMonitor[]{monitor});
        }
    }

    @Override
    protected void doInit() {
        this.initMetricsMonitor();
    }

    protected void initMetricsMonitor() {
        if (this.globalCacheConfig.getStatIntervalMinutes() > 0) {
            this.defaultMetricsManager = new DefaultMetricsManager(this.globalCacheConfig.getStatIntervalMinutes(), TimeUnit.MINUTES, this.metricsCallback);
            this.defaultMetricsManager.start();
        }
    }

    @Override
    protected void doShutdown() {
        this.shutdownMetricsMonitor();
    }

    protected void shutdownMetricsMonitor() {
        if (this.defaultMetricsManager != null) {
            this.defaultMetricsManager.stop();
        }
        this.defaultMetricsManager = null;
    }

    public void setGlobalCacheConfig(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
    }

    public void setMetricsCallback(Consumer<StatInfo> metricsCallback) {
        this.metricsCallback = metricsCallback;
    }

    public void setConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }
}

