/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.anno.support.EncoderParser;
import com.alicp.jetcache.support.JavaValueDecoder;
import com.alicp.jetcache.support.JavaValueEncoder;
import com.alicp.jetcache.support.KryoValueDecoder;
import com.alicp.jetcache.support.KryoValueEncoder;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class DefaultEncoderParser
implements EncoderParser {
    protected static Map<String, String> parseQueryParameters(String query) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String value;
                int idx = pair.indexOf("=");
                String key = idx > 0 ? pair.substring(0, idx) : pair;
                String string = value = idx > 0 && pair.length() > idx + 1 ? pair.substring(idx + 1) : null;
                if (key == null || value == null) continue;
                m.put(key, value);
            }
        }
        return m;
    }

    JavaValueDecoder javaValueDecoder(boolean useIdentityNumber) {
        return new JavaValueDecoder(useIdentityNumber);
    }

    @Override
    public Function<Object, byte[]> parseEncoder(String valueEncoder) {
        if (valueEncoder == null) {
            throw new CacheConfigException("no serialPolicy");
        }
        valueEncoder = valueEncoder.trim();
        URI uri = URI.create(valueEncoder);
        valueEncoder = uri.getPath();
        Map<String, String> params = DefaultEncoderParser.parseQueryParameters(uri.getQuery());
        boolean useIdentityNumber = true;
        if ("false".equalsIgnoreCase(params.get("useIdentityNumber"))) {
            useIdentityNumber = false;
        }
        if ("KRYO".equalsIgnoreCase(valueEncoder)) {
            return new KryoValueEncoder(useIdentityNumber);
        }
        if ("JAVA".equalsIgnoreCase(valueEncoder)) {
            return new JavaValueEncoder(useIdentityNumber);
        }
        throw new CacheConfigException("not supported:" + valueEncoder);
    }

    @Override
    public Function<byte[], Object> parseDecoder(String valueDecoder) {
        if (valueDecoder == null) {
            throw new CacheConfigException("no serialPolicy");
        }
        valueDecoder = valueDecoder.trim();
        URI uri = URI.create(valueDecoder);
        valueDecoder = uri.getPath();
        Map<String, String> params = DefaultEncoderParser.parseQueryParameters(uri.getQuery());
        boolean useIdentityNumber = true;
        if ("false".equalsIgnoreCase(params.get("useIdentityNumber"))) {
            useIdentityNumber = false;
        }
        if ("KRYO".equalsIgnoreCase(valueDecoder)) {
            return new KryoValueDecoder(useIdentityNumber);
        }
        if ("JAVA".equalsIgnoreCase(valueDecoder)) {
            return this.javaValueDecoder(useIdentityNumber);
        }
        throw new CacheConfigException("not supported:" + valueDecoder);
    }
}

