/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis.springdata;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.springdata.RedisSpringDataCache;
import com.alicp.jetcache.redis.springdata.RedisSpringDataCacheConfig;
import com.alicp.jetcache.redis.springdata.SpringDataBroadcastManager;
import com.alicp.jetcache.support.BroadcastManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class RedisSpringDataCacheBuilder<T extends ExternalCacheBuilder<T>>
extends ExternalCacheBuilder<T> {
    public static RedisSpringDataCacheBuilderImpl createBuilder() {
        return new RedisSpringDataCacheBuilderImpl();
    }

    protected RedisSpringDataCacheBuilder() {
        this.buildFunc(config -> new RedisSpringDataCache((RedisSpringDataCacheConfig)((Object)config)));
    }

    public RedisSpringDataCacheConfig getConfig() {
        if (this.config == null) {
            this.config = new RedisSpringDataCacheConfig();
        }
        return (RedisSpringDataCacheConfig)this.config;
    }

    public boolean supportBroadcast() {
        return true;
    }

    public BroadcastManager createBroadcastManager(CacheManager cacheManager) {
        RedisSpringDataCacheConfig c = (RedisSpringDataCacheConfig)this.getConfig().clone();
        return new SpringDataBroadcastManager(cacheManager, c);
    }

    public T connectionFactory(RedisConnectionFactory connectionFactory) {
        this.getConfig().setConnectionFactory(connectionFactory);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.getConfig().setConnectionFactory(connectionFactory);
    }

    public T listenerContainer(RedisMessageListenerContainer listenerContainer) {
        this.getConfig().setListenerContainer(listenerContainer);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setListenerContainer(RedisMessageListenerContainer listenerContainer) {
        this.getConfig().setListenerContainer(listenerContainer);
    }

    public static class RedisSpringDataCacheBuilderImpl
    extends RedisSpringDataCacheBuilder<RedisSpringDataCacheBuilderImpl> {
    }
}

