/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis;

import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.redis.RedisCacheConfig;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.commands.KeyBinaryCommands;
import redis.clients.jedis.commands.StringBinaryCommands;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.util.Pool;

public class RedisCache<K, V>
extends AbstractExternalCache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(RedisCache.class);
    protected RedisCacheConfig<K, V> config;
    Function<Object, byte[]> valueEncoder;
    Function<byte[], Object> valueDecoder;
    private static ThreadLocalRandom random = ThreadLocalRandom.current();

    public RedisCache(RedisCacheConfig<K, V> config) {
        super(config);
        this.config = config;
        this.valueEncoder = config.getValueEncoder();
        this.valueDecoder = config.getValueDecoder();
        if (config.getJedis() == null && config.getJedisPool() == null) {
            throw new CacheConfigException("no jedis");
        }
        if (config.getJedis() != null && config.getJedisPool() != null) {
            throw new CacheConfigException("'jedis' and 'jedisPool' can't set simultaneously");
        }
        if (config.getJedis() != null && config.getJedisSlavePools() != null) {
            throw new CacheConfigException("'jedisSlavePools' should work with 'jedisPool' in RedisCacheConfig");
        }
        if (config.getJedisPool() != null && config.getSlaves() != null) {
            throw new CacheConfigException("'slaves' should work with 'jedis' in RedisCacheConfig");
        }
        if (config.isReadFromSlave()) {
            if (this.slaveCount() == 0) {
                throw new CacheConfigException("slaves not config");
            }
            if (config.getSlaveReadWeights() == null) {
                this.initDefaultWeights();
            } else if (config.getSlaveReadWeights().length != this.slaveCount()) {
                logger.error("length of slaveReadWeights and jedisSlavePools not equals, using default weights");
                this.initDefaultWeights();
            }
        }
        if (config.isExpireAfterAccess()) {
            throw new CacheConfigException("expireAfterAccess is not supported");
        }
    }

    private int slaveCount() {
        if (this.config.getSlaves() != null) {
            return this.config.getSlaves().length;
        }
        if (this.config.getJedisSlavePools() != null) {
            return this.config.getJedisSlavePools().length;
        }
        return 0;
    }

    private void initDefaultWeights() {
        int len = this.slaveCount();
        int[] weights = new int[len];
        Arrays.fill(weights, 100);
        this.config.setSlaveReadWeights(weights);
    }

    public CacheConfig<K, V> config() {
        return this.config;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (UnifiedJedis.class.isAssignableFrom(clazz)) {
            return (T)this.config.getJedis();
        }
        if (Pool.class.isAssignableFrom(clazz)) {
            return (T)this.config.getJedisPool();
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    Object writeCommands() {
        return this.config.getJedis() != null ? this.config.getJedis() : this.config.getJedisPool().getResource();
    }

    Object readCommands() {
        if (!this.config.isReadFromSlave()) {
            return this.writeCommands();
        }
        int[] weights = this.config.getSlaveReadWeights();
        int index = RedisCache.randomIndex(weights);
        if (this.config.getSlaves() != null) {
            return this.config.getSlaves()[index];
        }
        return this.config.getJedisSlavePools()[index].getResource();
    }

    static int randomIndex(int[] weights) {
        int sumOfWeights = 0;
        for (int w : weights) {
            sumOfWeights += w;
        }
        int r = random.nextInt(sumOfWeights);
        int x = 0;
        for (int i = 0; i < weights.length; ++i) {
            if (r >= (x += weights[i])) continue;
            return i;
        }
        throw new CacheException("assert false");
    }

    static void closeJedis(Object maybeJedis) {
        if (maybeJedis instanceof Jedis) {
            RedisCache.close((Closeable)((Jedis)maybeJedis));
        }
    }

    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("close jedis resource error: {}", (Object)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheGetResult<V> do_GET(K key) {
        CacheGetResult cacheGetResult;
        StringBinaryCommands commands;
        block6: {
            CacheValueHolder holder;
            block7: {
                commands = null;
                byte[] newKey = this.buildKey(key);
                commands = (StringBinaryCommands)this.readCommands();
                byte[] bytes = commands.get(newKey);
                if (bytes == null) break block6;
                holder = (CacheValueHolder)this.valueDecoder.apply(bytes);
                if (System.currentTimeMillis() < holder.getExpireTime()) break block7;
                CacheGetResult cacheGetResult2 = CacheGetResult.EXPIRED_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheGetResult2;
            }
            CacheGetResult cacheGetResult3 = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
            RedisCache.closeJedis(commands);
            return cacheGetResult3;
        }
        try {
            cacheGetResult = CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
        }
        catch (Exception ex) {
            CacheGetResult cacheGetResult4;
            try {
                this.logError("GET", key, ex);
                cacheGetResult4 = new CacheGetResult((Throwable)ex);
            }
            catch (Throwable throwable) {
                RedisCache.closeJedis(commands);
                throw throwable;
            }
            RedisCache.closeJedis(commands);
            return cacheGetResult4;
        }
        RedisCache.closeJedis(commands);
        return cacheGetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        MultiGetResult multiGetResult;
        StringBinaryCommands commands = null;
        HashMap<K, CacheGetResult> resultMap = new HashMap<K, CacheGetResult>();
        try {
            ArrayList<K> keyList = new ArrayList<K>(keys);
            byte[][] newKeys = (byte[][])keyList.stream().map(k -> this.buildKey(k)).toArray(x$0 -> new byte[x$0][]);
            if (newKeys.length > 0) {
                commands = (StringBinaryCommands)this.readCommands();
                if (commands instanceof JedisCluster) {
                    this.jedisClusterGetAll((JedisCluster)commands, resultMap, keyList, newKeys);
                } else {
                    List mgetResults = commands.mget(newKeys);
                    for (int i = 0; i < mgetResults.size(); ++i) {
                        Object value = mgetResults.get(i);
                        K key = keyList.get(i);
                        if (value != null) {
                            CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply((byte[])value);
                            if (System.currentTimeMillis() >= holder.getExpireTime()) {
                                resultMap.put(key, CacheGetResult.EXPIRED_WITHOUT_MSG);
                                continue;
                            }
                            CacheGetResult r = new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                            resultMap.put(key, r);
                            continue;
                        }
                        resultMap.put(key, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                    }
                }
            }
            multiGetResult = new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
        }
        catch (Exception ex) {
            block11: {
                MultiGetResult multiGetResult2;
                try {
                    this.logError("GET_ALL", "keys(" + keys.size() + ")", ex);
                    if (resultMap.size() <= 0) break block11;
                    multiGetResult2 = new MultiGetResult(CacheResultCode.PART_SUCCESS, ex.toString(), resultMap);
                }
                catch (Throwable throwable) {
                    RedisCache.closeJedis(commands);
                    throw throwable;
                }
                RedisCache.closeJedis(commands);
                return multiGetResult2;
            }
            MultiGetResult multiGetResult3 = new MultiGetResult((Throwable)ex);
            RedisCache.closeJedis(commands);
            return multiGetResult3;
        }
        RedisCache.closeJedis(commands);
        return multiGetResult;
    }

    private void jedisClusterGetAll(JedisCluster commands, Map<K, CacheGetResult<V>> resultMap, ArrayList<K> keyList, byte[][] newKeys) {
        for (int i = 0; i < newKeys.length; ++i) {
            byte[] bytes = commands.get(newKeys[i]);
            if (bytes != null) {
                CacheValueHolder holder = (CacheValueHolder)this.valueDecoder.apply(bytes);
                if (System.currentTimeMillis() >= holder.getExpireTime()) {
                    resultMap.put(keyList.get(i), CacheGetResult.EXPIRED_WITHOUT_MSG);
                    continue;
                }
                resultMap.put(keyList.get(i), new CacheGetResult(CacheResultCode.SUCCESS, null, holder));
                continue;
            }
            resultMap.put(keyList.get(i), CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        CacheResult cacheResult;
        StringBinaryCommands commands = null;
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            commands = (StringBinaryCommands)this.writeCommands();
            String rt = commands.psetex(newKey, timeUnit.toMillis(expireAfterWrite), this.valueEncoder.apply(holder));
            if ("OK".equals(rt)) {
                CacheResult cacheResult2 = CacheResult.SUCCESS_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheResult2;
            }
            cacheResult = new CacheResult(CacheResultCode.FAIL, rt);
            RedisCache.closeJedis(commands);
        }
        catch (Exception ex) {
            this.logError("PUT", key, ex);
            CacheResult cacheResult3 = new CacheResult((Throwable)ex);
            return cacheResult3;
        }
        finally {
            RedisCache.closeJedis(commands);
        }
        return cacheResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        CacheResult cacheResult;
        StringBinaryCommands commands = null;
        Connection connection = null;
        try {
            commands = (StringBinaryCommands)this.writeCommands();
            int failCount = 0;
            if (commands instanceof Jedis || commands instanceof JedisPooled) {
                ArrayList<Response> responses = new ArrayList<Response>();
                Pipeline pipeline = null;
                if (commands instanceof JedisPooled) {
                    connection = (Connection)((JedisPooled)commands).getPool().getResource();
                    pipeline = new Pipeline(connection);
                } else {
                    pipeline = new Pipeline((Jedis)commands);
                }
                for (Map.Entry<K, V> en : map.entrySet()) {
                    CacheValueHolder holder = new CacheValueHolder(en.getValue(), timeUnit.toMillis(expireAfterWrite));
                    Response resp = pipeline.psetex(this.buildKey(en.getKey()), timeUnit.toMillis(expireAfterWrite), this.valueEncoder.apply(holder));
                    responses.add(resp);
                }
                pipeline.sync();
                for (Response resp : responses) {
                    if ("OK".equals(resp.get())) continue;
                    ++failCount;
                }
            } else {
                for (Map.Entry<K, V> en : map.entrySet()) {
                    CacheResult r = this.do_PUT(en.getKey(), en.getValue(), expireAfterWrite, timeUnit);
                    if (r.isSuccess()) continue;
                    ++failCount;
                }
            }
            cacheResult = failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == map.size() ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
        }
        catch (Exception ex) {
            CacheResult cacheResult2;
            try {
                this.logError("PUT_ALL", "map(" + map.size() + ")", ex);
                cacheResult2 = new CacheResult((Throwable)ex);
            }
            catch (Throwable throwable) {
                RedisCache.closeJedis(commands);
                RedisCache.close(connection);
                throw throwable;
            }
            RedisCache.closeJedis(commands);
            RedisCache.close((Closeable)connection);
            return cacheResult2;
        }
        RedisCache.closeJedis(commands);
        RedisCache.close((Closeable)connection);
        return cacheResult;
    }

    protected CacheResult do_REMOVE(K key) {
        return this.REMOVE_impl(key, this.buildKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheResult REMOVE_impl(Object key, byte[] newKey) {
        KeyBinaryCommands commands = null;
        try {
            commands = (KeyBinaryCommands)this.writeCommands();
            Long rt = commands.del(newKey);
            if (rt == null) {
                CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
                return cacheResult;
            }
            if (rt == 1L) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                return cacheResult;
            }
            if (rt == 0L) {
                CacheResult cacheResult = new CacheResult(CacheResultCode.NOT_EXISTS, null);
                return cacheResult;
            }
            CacheResult cacheResult = CacheResult.FAIL_WITHOUT_MSG;
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("REMOVE", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            RedisCache.closeJedis(commands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        CacheResult cacheResult;
        KeyBinaryCommands commands = null;
        int x = 0;
        try {
            byte[][] newKeys = (byte[][])keys.stream().map(k -> this.buildKey(k)).toArray(len -> new byte[keys.size()][]);
            commands = (KeyBinaryCommands)this.writeCommands();
            if (commands instanceof JedisCluster) {
                for (byte[] newKey : newKeys) {
                    commands.del(newKey);
                    ++x;
                }
            } else {
                commands.del(newKeys);
            }
            cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
        }
        catch (Exception ex) {
            block8: {
                CacheResult cacheResult2;
                try {
                    this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", ex);
                    if (!(commands instanceof JedisCluster) || x <= 0) break block8;
                    cacheResult2 = new CacheResult(CacheResultCode.PART_SUCCESS, ex.toString());
                }
                catch (Throwable throwable) {
                    RedisCache.closeJedis(commands);
                    throw throwable;
                }
                RedisCache.closeJedis(commands);
                return cacheResult2;
            }
            CacheResult cacheResult3 = new CacheResult((Throwable)ex);
            RedisCache.closeJedis(commands);
            return cacheResult3;
        }
        RedisCache.closeJedis(commands);
        return cacheResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        StringBinaryCommands commands = null;
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            byte[] newKey = this.buildKey(key);
            SetParams params = new SetParams();
            params.nx().px(timeUnit.toMillis(expireAfterWrite));
            commands = (StringBinaryCommands)this.writeCommands();
            String rt = commands.set(newKey, this.valueEncoder.apply(holder), params);
            if ("OK".equals(rt)) {
                CacheResult cacheResult = CacheResult.SUCCESS_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheResult;
            }
            if (rt == null) {
                CacheResult cacheResult = CacheResult.EXISTS_WITHOUT_MSG;
                RedisCache.closeJedis(commands);
                return cacheResult;
            }
            CacheResult cacheResult = new CacheResult(CacheResultCode.FAIL, rt);
            RedisCache.closeJedis(commands);
            return cacheResult;
        }
        catch (Exception ex) {
            this.logError("PUT_IF_ABSENT", key, ex);
            CacheResult cacheResult = new CacheResult((Throwable)ex);
            return cacheResult;
        }
        finally {
            RedisCache.closeJedis(commands);
        }
    }
}

