/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.jarslink.api;

import com.alipay.jarslink.api.ToStringObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ModuleConfig
extends ToStringObject {
    private String name;
    private String desc;
    private Boolean enabled = true;
    private Set<String> scanPackages = new CopyOnWriteArraySet<String>();
    private String version;
    private Map<String, Object> properties = Maps.newHashMap();
    private List<String> overridePackages = Lists.newArrayList();
    private List<URL> moduleUrl = Lists.newArrayList();
    private boolean isNeedUnloadOldVersion = true;

    public boolean isNeedUnloadOldVersion() {
        return this.isNeedUnloadOldVersion;
    }

    public void setNeedUnloadOldVersion(boolean needUnloadOldVersion) {
        this.isNeedUnloadOldVersion = needUnloadOldVersion;
    }

    public List<URL> getModuleUrl() {
        return this.moduleUrl;
    }

    public List<String> getModuleUrlPath() {
        ArrayList moduleUrls = Lists.newArrayList();
        moduleUrls.addAll(this.moduleUrl.stream().map(URL::toString).collect(Collectors.toList()));
        return moduleUrls;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setModuleUrl(List<URL> moduleUrl) {
        this.moduleUrl = moduleUrl;
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)that, (String[])new String[0]);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)DEFAULT_TO_STRING_STYLE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModuleConfig addScanPackage(String packageName) {
        Preconditions.checkNotNull((Object)packageName, (Object)"packageName must not be null");
        this.scanPackages.add(packageName);
        return this;
    }

    public ModuleConfig removeScanPackage(String packageName) {
        Preconditions.checkNotNull((Object)packageName, (Object)"packageName must not be null");
        this.scanPackages.remove(packageName);
        return this;
    }

    public Set<String> getScanPackages() {
        return this.scanPackages;
    }

    public ModuleConfig withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public ModuleConfig withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public ModuleConfig withProperties(Map<String, Object> properties) {
        this.setProperties(properties);
        return this;
    }

    public ModuleConfig withOverridePackages(List<String> overridePackages) {
        this.setOverridePackages(overridePackages);
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<String> getOverridePackages() {
        return this.overridePackages;
    }

    public void setOverridePackages(List<String> overridePackages) {
        this.overridePackages = overridePackages;
    }

    public ModuleConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public ModuleConfig addModuleUrl(URL url) {
        this.moduleUrl.add(url);
        return this;
    }

    public ModuleConfig withNeedUnloadOldVersion(boolean needUnloadOldVersion) {
        this.setNeedUnloadOldVersion(needUnloadOldVersion);
        return this;
    }
}

